/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TobagoResponseWriterBase
extends TobagoResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoResponseWriterBase.class);
    protected static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static final char[] XML_VERSION_1_0_ENCODING_UTF_8_CHARS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".toCharArray();
    private int i = 0;
    private int inlineStack = 0;
    private UIComponent component;
    private boolean startStillOpen;
    private final Writer writer;
    private final String contentType;
    private final String characterEncoding;
    private final boolean ajax;

    protected TobagoResponseWriterBase(Writer writer, String contentType, String characterEncoding) {
        this.writer = writer;
        this.contentType = contentType;
        this.characterEncoding = characterEncoding != null ? characterEncoding : "UTF-8";
        this.ajax = FacesContext.getCurrentInstance().getPartialViewContext().isPartialRequest();
    }

    protected final Writer getWriter() {
        return this.writer;
    }

    protected final UIComponent getComponent() {
        return this.component;
    }

    protected final void setComponent(UIComponent component) {
        this.component = component;
    }

    protected final boolean isStartStillOpen() {
        return this.startStillOpen;
    }

    protected final void setStartStillOpen(boolean startStillOpen) {
        this.startStillOpen = startStillOpen;
    }

    protected final String findValue(Object value, String property) {
        if (value != null) {
            return value instanceof String ? (String)value : value.toString();
        }
        if (property != null) {
            if (this.component != null) {
                Object object = this.component.getAttributes().get(property);
                if (object != null) {
                    return object instanceof String ? (String)object : object.toString();
                }
                return null;
            }
            String trace = this.getCallingClassStackTraceElementString();
            LOG.warn("Don't know what to do! Property defined, but no component to get a value. (value=null, property='" + property + "') " + trace.substring(trace.indexOf(40)));
            return null;
        }
        String trace = this.getCallingClassStackTraceElementString();
        LOG.warn("Don't know what to do! No value and no property defined. (value=null, property=null)" + trace.substring(trace.indexOf(40)));
        return null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(String string) throws IOException {
        this.writeInternal(this.writer, string);
    }

    protected final void writeInternal(Writer writer, String string) throws IOException {
        this.closeOpenTag();
        writer.write(string);
    }

    public void write(int i) throws IOException {
        this.closeOpenTag();
        this.writer.write(i);
    }

    public void write(char[] chars) throws IOException {
        this.closeOpenTag();
        this.writer.write(chars);
    }

    public void write(String string, int i, int i1) throws IOException {
        this.closeOpenTag();
        this.writer.write(string, i, i1);
    }

    public void close() throws IOException {
        this.closeOpenTag();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.closeOpenTag();
    }

    protected void closeOpenTag() throws IOException {
        if (this.startStillOpen) {
            this.writer.write(">");
            this.startStillOpen = false;
        }
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void startElement(String name, UIComponent currentComponent) throws IOException {
        boolean inline = HtmlElements.isInline(name);
        if (inline) {
            ++this.inlineStack;
        }
        this.component = currentComponent;
        this.startElementInternal(this.writer, name, HtmlElements.isInline(name));
    }

    @Override
    public void startElement(HtmlElements name) throws IOException {
        boolean inline = name.isInline();
        if (inline) {
            ++this.inlineStack;
        }
        this.startElementInternal(this.writer, name.getValue(), name.isInline());
        if (!name.isVoid()) {
            ++this.i;
        }
    }

    protected void startElementInternal(Writer writer, String name, boolean inline) throws IOException {
        if (this.startStillOpen) {
            writer.write(">");
        }
        if (!this.ajax && this.inlineStack <= 1) {
            writer.write("\n");
            writer.write(StringUtils.repeat("  ", this.i));
        }
        writer.write("<");
        writer.write(name);
        this.startStillOpen = true;
    }

    @Override
    public void endElement(String name) throws IOException {
        boolean inline = HtmlElements.isInline(name);
        if (HtmlElements.isVoid(name)) {
            this.closeEmptyTag();
        } else {
            this.endElementInternal(this.writer, name, inline);
        }
        this.startStillOpen = false;
        if (inline) {
            --this.inlineStack;
            assert (this.inlineStack >= 0);
        }
    }

    @Override
    public void endElement(HtmlElements name) throws IOException {
        boolean inline = name.isInline();
        if (name.isVoid()) {
            this.closeEmptyTag();
        } else {
            if (!name.isVoid()) {
                --this.i;
            }
            this.endElementInternal(this.writer, name.getValue(), inline);
        }
        this.startStillOpen = false;
        if (inline) {
            --this.inlineStack;
            assert (this.inlineStack >= 0);
        }
    }

    @Override
    public void writeComment(Object obj) throws IOException {
        this.closeOpenTag();
        String comment = obj.toString();
        if (!this.ajax) {
            this.writer.write("\n");
            this.writer.write(StringUtils.repeat("  ", this.i));
        }
        this.write("<!--");
        this.write(comment);
        this.write("-->");
    }

    @Override
    @Deprecated
    public void writeAttribute(final String name, Object value, String property) throws IOException {
        String attribute = this.findValue(value, property);
        this.writeAttribute(new MarkupLanguageAttributes(){

            @Override
            public String getValue() {
                return name;
            }
        }, attribute, true);
    }

    protected final String getCallingClassStackTraceElementString() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        int i = 1;
        while (stackTrace[i].getClassName().contains("ResponseWriter")) {
            ++i;
        }
        return stackTrace[i].toString();
    }

    @Override
    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (value != null) {
            URI uri = URI.create(value.toString());
            this.writeAttribute(name, (Object)uri.toASCIIString(), property);
        }
    }

    @Override
    public void writeAttribute(MarkupLanguageAttributes name, String value, boolean escape) throws IOException {
        this.writeAttributeInternal(this.writer, name, value, escape);
    }

    @Override
    public void writeAttribute(MarkupLanguageAttributes name, HtmlTypes types) throws IOException {
        this.writeAttributeInternal(this.writer, name, types.getValue(), false);
    }

    @Override
    public void writeURIAttribute(MarkupLanguageAttributes name, String value) throws IOException {
        if (value != null) {
            URI uri = URI.create(value);
            this.writeAttribute(name, uri.toASCIIString(), true);
        }
    }

    protected void endElementInternal(Writer writer, String name, boolean inline) throws IOException {
        if (this.startStillOpen) {
            writer.write(">");
        }
        if (inline || this.ajax) {
            writer.write("</");
        } else {
            writer.write("\n" + StringUtils.repeat("  ", this.i) + "</");
        }
        writer.write(name);
        writer.write(">");
    }

    protected abstract void closeEmptyTag() throws IOException;

    protected void writeAttributeInternal(Writer writer, MarkupLanguageAttributes name, String value, boolean escape) throws IOException {
        if (!this.startStillOpen) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + name + "' value = '" + value + "' " + trace.substring(trace.indexOf(40));
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        if (value != null) {
            writer.write(32);
            writer.write(name.getValue());
            writer.write("='");
            this.writerAttributeValue(value, escape);
            writer.write(39);
        }
    }

    protected abstract void writerAttributeValue(String var1, boolean var2) throws IOException;
}

