/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.FastStringWriter;
import org.apache.myfaces.tobago.internal.util.HtmlWriterUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.WriterUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;

public class HtmlResponseWriter
extends TobagoResponseWriterBase {
    private static final String HTML_DOCTYPE = "<!DOCTYPE html>";
    private final WriterUtils helper;
    private FastStringWriter javascriptWriter;
    private boolean javascriptMode;

    public HtmlResponseWriter(Writer writer, String contentType, String characterEncoding) {
        super(writer, contentType, characterEncoding);
        this.helper = new HtmlWriterUtils(writer, characterEncoding);
        this.javascriptWriter = new FastStringWriter();
    }

    @Override
    @Deprecated
    public void endJavascript() throws IOException {
        this.javascriptMode = false;
    }

    @Override
    @Deprecated
    public void startJavascript() throws IOException {
        this.javascriptMode = true;
    }

    @Override
    public void write(String string) throws IOException {
        if (this.javascriptMode) {
            this.writeJavascript(string);
        } else {
            this.writeInternal(this.getWriter(), string);
        }
    }

    @Override
    @Deprecated
    public void writeJavascript(String script) throws IOException {
        this.writeInternal(this.javascriptWriter, script);
    }

    public String getJavascript() {
        return this.javascriptWriter.toString();
    }

    public final WriterUtils getHelper() {
        return this.helper;
    }

    @Override
    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        this.helper.writeText(value);
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        this.closeOpenTag();
        this.helper.writeText(text, offset, length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!Arrays.equals(cbuf, XML_VERSION_1_0_ENCODING_UTF_8_CHARS)) {
            super.write(cbuf, off, len);
        }
    }

    @Override
    protected void closeEmptyTag() throws IOException {
        this.getWriter().write(">");
    }

    @Override
    protected void writerAttributeValue(String value, boolean escape) throws IOException {
        if (escape) {
            this.helper.writeAttributeValue(value);
        } else {
            this.getWriter().write(value);
        }
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new HtmlResponseWriter(originalWriter, this.getContentType(), this.getCharacterEncoding());
    }

    @Override
    public void startDocument() throws IOException {
        this.getWriter().write(HTML_DOCTYPE);
        this.getWriter().write(10);
    }

    @Override
    public void endElement(String name) throws IOException {
        String javascript;
        if (name.equals(HtmlElements.BODY.getValue()) && StringUtils.isNotEmpty(javascript = this.getJavascript())) {
            this.startElement(HtmlElements.SCRIPT);
            this.writeAttribute(HtmlAttributes.TYPE, "text/javascript", false);
            this.write(javascript);
            super.endElement(HtmlElements.SCRIPT);
        }
        super.endElement(name);
    }

    @Override
    public void endDocument() throws IOException {
    }
}

