/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.myfaces.tobago.config.TobagoConfig;

public final class MimeTypeUtils {
    private static Map<String, String> additionalMimeTypes = null;

    private MimeTypeUtils() {
    }

    public static String getMimeTypeForFile(String file) {
        int index;
        int length = file.length();
        if (file.charAt(length - 4) == '.') {
            if (file.charAt(length - 1) == 'g') {
                if (file.regionMatches(length - 3, "png", 0, 2)) {
                    return "image/png";
                }
                if (file.regionMatches(length - 3, "jpg", 0, 2)) {
                    return "image/jpeg";
                }
                if (file.endsWith("svg")) {
                    return "image/svg+xml";
                }
            } else {
                if (file.endsWith("css")) {
                    return "text/css";
                }
                if (file.endsWith("gif")) {
                    return "image/gif";
                }
                if (file.endsWith("htm")) {
                    return "text/html";
                }
                if (file.endsWith("ico")) {
                    return "image/vnd.microsoft.icon";
                }
                if (file.endsWith("map")) {
                    return "application/json";
                }
                if (file.endsWith("ttf")) {
                    return "application/x-font-ttf";
                }
                if (file.endsWith("eot")) {
                    return "application/vnd.ms-fontobject";
                }
            }
        } else if (file.charAt(length - 3) == '.') {
            if (file.endsWith("js")) {
                return "text/javascript";
            }
        } else if (file.charAt(length - 5) == '.') {
            if (file.endsWith("woff")) {
                return "application/font-woff";
            }
            if (file.endsWith("html")) {
                return "text/html";
            }
        } else if (file.charAt(length - 6) == '.' && file.endsWith("woff2")) {
            return "application/font-woff2";
        }
        if ((index = file.lastIndexOf(46)) > -1) {
            String extension = file.substring(index + 1);
            return additionalMimeTypes.get(extension);
        }
        return null;
    }

    public static void init(ServletContext servletContext) {
        if (additionalMimeTypes != null) {
            throw new IllegalStateException(MimeTypeUtils.class.getSimpleName() + " is already initialized!");
        }
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(servletContext);
        additionalMimeTypes = tobagoConfig.getMimeTypes();
    }
}

