/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.collections.set.ListOrderedSet;

public final class FacesContextUtils {
    private static final String TOBAGO_ENCTYPE = "org.apache.myfaces.tobago.enctype";
    private static final String TOBAGO_SCRIPT_FILES = "org.apache.myfaces.tobago.scriptFiles";
    private static final String TOBAGO_STYLE_FILES = "org.apache.myfaces.tobago.styleFiles";
    private static final String TOBAGO_FOCUS_ID = "org.apache.myfaces.tobago.focusId";

    private FacesContextUtils() {
    }

    public static void setFocusId(FacesContext context, String focusId) {
        context.getAttributes().put(TOBAGO_FOCUS_ID, focusId);
    }

    public static String getFocusId(FacesContext context) {
        return (String)context.getAttributes().get(TOBAGO_FOCUS_ID);
    }

    public static String getEnctype(FacesContext context) {
        return (String)context.getAttributes().get(TOBAGO_ENCTYPE);
    }

    public static void setEnctype(FacesContext context, String enctype) {
        context.getAttributes().put(TOBAGO_ENCTYPE, enctype);
    }

    public static List<String> getScriptFiles(FacesContext context) {
        List list = (List)context.getAttributes().get(TOBAGO_SCRIPT_FILES);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static void addScriptFile(FacesContext context, String file) {
        List list = (List)context.getAttributes().get(TOBAGO_SCRIPT_FILES);
        if (list == null) {
            list = SetUniqueList.decorate(new ArrayList());
            context.getAttributes().put(TOBAGO_SCRIPT_FILES, list);
        }
        list.add(file);
    }

    public static Set<String> getStyleFiles(FacesContext context) {
        Set set = (Set)context.getAttributes().get(TOBAGO_STYLE_FILES);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public static void addStyleFile(FacesContext context, String script) {
        Set set = (Set)context.getAttributes().get(TOBAGO_STYLE_FILES);
        if (set == null) {
            set = new ListOrderedSet();
            context.getAttributes().put(TOBAGO_STYLE_FILES, set);
        }
        set.add(script);
    }
}

