/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeIcon;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.FontAwesomeIconEncoder;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIconRenderer
extends RendererBase {
    @Deprecated
    protected static final String OPEN_FOLDER = "image/treeNode-icon-open";
    @Deprecated
    protected static final String CLOSED_FOLDER = "image/treeNode-icon";
    @Deprecated
    protected static final String LEAF = "image/treeNode-icon-leaf";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeIcon image = (UITreeIcon)component;
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)image, AbstractUIData.class);
        UITreeNode node = ComponentUtils.findAncestor((UIComponent)image, UITreeNode.class);
        boolean folder = node.isFolder();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        String value = (String)image.getValue();
        String closed = image.getClosed();
        String open = image.getOpen();
        if (closed == null) {
            closed = value;
        }
        if (open == null) {
            open = closed;
        }
        String source = folder ? (expanded ? open : closed) : value;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(image.getClientId());
        writer.writeClassAttribute(TobagoClass.TREE_NODE__TOGGLE);
        if (StringUtils.startsWith(source, "fa-")) {
            writer.startElement(HtmlElements.I);
            writer.writeStyleAttribute(image.getStyle());
            writer.writeClassAttribute(FontAwesomeIconEncoder.FA, FontAwesomeIconEncoder.generateClass(source));
            if (folder) {
                writer.writeAttribute(DataAttributes.SRC_OPEN, open, true);
                writer.writeAttribute(DataAttributes.SRC_CLOSED, closed, true);
            }
            writer.endElement(HtmlElements.I);
        } else {
            writer.startElement(HtmlElements.IMG);
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)image);
            writer.writeAttribute(HtmlAttributes.SRC, source, true);
            if (folder) {
                writer.writeAttribute(DataAttributes.SRC_OPEN, open, true);
                writer.writeAttribute(DataAttributes.SRC_CLOSED, closed, true);
            }
            writer.writeAttribute(HtmlAttributes.ALT, "", false);
            writer.endElement(HtmlElements.IMG);
        }
        writer.endElement(HtmlElements.SPAN);
    }
}

