/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.UITextarea;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextareaRenderer
extends LabelLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TextareaRenderer.class);

    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UITextarea)) {
            LOG.error("Wrong type: Need " + UITextarea.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UITextarea input = (UITextarea)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String clientId = input.getClientId(facesContext);
        String fieldId = input.getFieldId(facesContext);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Integer rows = input.getRows();
        writer.startElement(HtmlElements.TEXTAREA);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)input);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWS, rows);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, input.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, input.isDisabled());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, input.isRequired());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, input.getTabIndex());
        if (input.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(input.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, input.getAccessKey(), clientId);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)input), BootstrapClass.FORM_CONTROL, input.getCustomClass());
        writer.writeStyleAttribute(input.getStyle());
        int maxLength = -1;
        String pattern = null;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof LengthValidator)) continue;
            LengthValidator lengthValidator = (LengthValidator)validator;
            maxLength = lengthValidator.getMaximum();
        }
        if (maxLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
        }
        if (pattern != null) {
            writer.writeAttribute(HtmlAttributes.PATTERN, pattern, false);
        }
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, input)));
        HtmlRendererUtils.renderFocus(clientId, input.isFocus(), ComponentUtils.isError(input), facesContext, writer);
        String currentValue = RenderUtils.currentValue((UIComponent)input);
        if (currentValue != null) {
            if (ComponentUtils.getDataAttribute((UIComponent)input, "html-editor") != null && SanitizeMode.auto == input.getSanitize()) {
                Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                currentValue = sanitizer.sanitize(currentValue);
            }
            if (currentValue.startsWith("\r\n")) {
                currentValue = "\r\n" + currentValue;
            } else if (currentValue.startsWith("\n")) {
                currentValue = "\n" + currentValue;
            } else if (currentValue.startsWith("\r")) {
                currentValue = "\r" + currentValue;
            }
            writer.writeText(currentValue);
        }
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TEXTAREA);
    }
}

