/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectOneRadio;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneRadioRenderer
extends SelectOneRendererBase {
    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectOneRadio select = (UISelectOneRadio)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String id = select.getClientId(facesContext);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        boolean readonly = select.isReadonly();
        boolean required = select.isRequired();
        boolean inline = select.isInline();
        writer.startElement(HtmlElements.OL);
        writer.writeStyleAttribute(select.getStyle());
        writer.writeClassAttribute(Classes.create((UIComponent)select), inline ? TobagoClass.SELECT_ONE_RADIO__INLINE : null, select.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        boolean first = true;
        Object value = select.getValue();
        String submittedValue = (String)select.getSubmittedValue();
        int i = 0;
        for (SelectItem item : items) {
            String label;
            org.apache.myfaces.tobago.model.SelectItem tobagoItem;
            String image;
            boolean itemDisabled = item.isDisabled() || disabled;
            String itemId = id + "::" + i++;
            writer.startElement(HtmlElements.LI);
            writer.writeClassAttribute(BootstrapClass.FORM_CHECK, inline ? BootstrapClass.FORM_CHECK_INLINE : null, itemDisabled ? BootstrapClass.DISABLED : null);
            writer.startElement(HtmlElements.LABEL);
            writer.writeClassAttribute(BootstrapClass.FORM_CHECK_LABEL);
            writer.startElement(HtmlElements.INPUT);
            writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INPUT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
            String formattedValue = ComponentUtils.getFormattedValue(facesContext, (UIComponent)select, item.getValue());
            boolean checked = submittedValue == null ? ObjectUtils.equals(item.getValue(), value) : ObjectUtils.equals(formattedValue, submittedValue);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(itemId);
            writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, itemDisabled);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
            if (first) {
                HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
                first = false;
            }
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
            writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
            writer.endElement(HtmlElements.INPUT);
            if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = (tobagoItem = (org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                writer.startElement(HtmlElements.IMG);
                writer.writeAttribute(HtmlAttributes.SRC, image, true);
                writer.writeAttribute(HtmlAttributes.ALT, "", false);
                writer.endElement(HtmlElements.IMG);
            }
            if ((label = item.getLabel()) != null) {
                writer.writeText(label);
            }
            writer.endElement(HtmlElements.LABEL);
            writer.endElement(HtmlElements.LI);
        }
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.OL);
    }
}

