/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUISection;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SectionRenderer
extends PanelRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        HtmlElements tag;
        AbstractUISection section = (AbstractUISection)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = section.getClientId(facesContext);
        boolean collapsed = section.isCollapsed();
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)section), collapsed ? TobagoClass.COLLAPSED : null, section.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)section);
        String label = section.getLabelToRender();
        switch (section.getLevel()) {
            case 1: {
                tag = HtmlElements.H1;
                break;
            }
            case 2: {
                tag = HtmlElements.H2;
                break;
            }
            case 3: {
                tag = HtmlElements.H3;
                break;
            }
            case 4: {
                tag = HtmlElements.H4;
                break;
            }
            case 5: {
                tag = HtmlElements.H5;
                break;
            }
            default: {
                tag = HtmlElements.H6;
            }
        }
        if (section.getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.SECTION__HEADER);
        writer.startElement(tag);
        String image = section.getImage();
        HtmlRendererUtils.encodeIconWithLabel(writer, image, label);
        writer.endElement(tag);
        UIComponent bar = ComponentUtils.getFacet((UIComponent)section, Facets.bar);
        if (bar != null) {
            RenderUtils.encode(facesContext, bar);
        }
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.SECTION__CONTENT);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
    }
}

