/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIProgress;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIProgress progress = (UIProgress)component;
        double value = progress.getRangeValue();
        double max = progress.getRangeMax();
        String title = progress.getTip();
        if (title == null && max > 0.0) {
            title = Integer.toString((int)(value / max)) + " %";
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.PROGRESS);
        writer.writeIdAttribute(progress.getClientId(facesContext));
        writer.writeClassAttribute(Classes.create((UIComponent)progress), progress.getCustomClass(), BootstrapClass.PROGRESS);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)progress);
        writer.writeStyleAttribute(progress.getStyle());
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute(HtmlAttributes.MAX, Double.toString(max), false);
        writer.writeAttribute(HtmlAttributes.VALUE, Double.toString(value), false);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, progress)));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.PROGRESS);
    }
}

