/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PanelRenderer
extends PanelRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIComponent reloadFacet;
        UIPanel panel = (UIPanel)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = panel.getClientId(facesContext);
        boolean collapsed = panel.isCollapsed();
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)panel), panel.getCustomClass(), collapsed ? TobagoClass.COLLAPSED : null);
        writer.writeStyleAttribute(panel.getStyle());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)panel);
        String tip = panel.getTip();
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        if ((reloadFacet = ComponentUtils.getFacet((UIComponent)panel, Facets.reload)) instanceof UIReload && reloadFacet.isRendered()) {
            UIReload update = (UIReload)reloadFacet;
            writer.writeAttribute(DataAttributes.RELOAD, Integer.toString(update.getFrequency()), false);
        }
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, panel)));
        if (panel.getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }
}

