/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.CookieUtils;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PageRenderer.class);
    private static final String LAST_FOCUS_ID = "lastFocusId";
    private static final String HEAD_TARGET = "head";

    public void decode(FacesContext facesContext, UIComponent component) {
        AbstractUIPage page = (AbstractUIPage)component;
        String clientId = page.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        String lastFocusId = (String)externalContext.getRequestParameterMap().get(clientId + "::" + LAST_FOCUS_ID);
        if (lastFocusId != null) {
            FacesContextUtils.setFocusId(facesContext, lastFocusId);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoClass spread;
        String partialAction;
        boolean portlet;
        UIPage page = (UIPage)component;
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        if (FacesContextUtils.getFocusId(facesContext) == null && !StringUtils.isBlank(page.getFocusId())) {
            FacesContextUtils.setFocusId(facesContext, page.getFocusId());
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        facesContext.setResponseWriter((ResponseWriter)writer);
        ResponseUtils.ensureNoCacheHeader(facesContext);
        ResponseUtils.ensureContentSecurityPolicyHeader(facesContext, tobagoConfig.getContentSecurityPolicy());
        if (LOG.isDebugEnabled()) {
            Iterator iterator = page.getAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                LOG.debug("*** '" + entry.getKey() + "' -> '" + entry.getValue() + "'");
            }
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        Object request = externalContext.getRequest();
        Object response = externalContext.getResponse();
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String viewId = viewRoot.getViewId();
        String formAction = externalContext.encodeActionURL(viewHandler.getActionURL(facesContext, viewId));
        boolean bl = portlet = PortletUtils.isPortletApiAvailable() && response instanceof MimeResponse;
        if (portlet) {
            MimeResponse mimeResponse = (MimeResponse)response;
            ResourceURL resourceURL = mimeResponse.createResourceURL();
            partialAction = externalContext.encodeResourceURL(resourceURL.toString());
        } else {
            partialAction = null;
        }
        String contentType = writer.getContentTypeWithCharSet();
        ResponseUtils.ensureContentTypeHeader(facesContext, contentType);
        if (tobagoConfig.isSetNosniffHeader()) {
            ResponseUtils.ensureNosniffHeader(facesContext);
        }
        Theme theme = TobagoContext.getInstance(facesContext).getTheme();
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest) {
            CookieUtils.setThemeNameToCookie((HttpServletRequest)request, (HttpServletResponse)response, theme.getName());
        }
        String clientId = page.getClientId(facesContext);
        boolean productionMode = tobagoConfig.getProjectStage() == ProjectStage.Production;
        boolean preventFrameAttacks = tobagoConfig.isPreventFrameAttacks();
        Markup markup = page.getMarkup();
        TobagoClass tobagoClass = spread = markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null;
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            String icon;
            String title = page.getLabel();
            if (!PortletUtils.isPortletApiAvailable() || !(response instanceof MimeResponse)) {
                String language;
                writer.startElement(HtmlElements.HTML);
                String[] locale = viewRoot.getLocale();
                if (locale != null && (language = locale.getLanguage()) != null) {
                    writer.writeAttribute(HtmlAttributes.LANG, language, false);
                }
            }
            writer.writeClassAttribute(spread);
            writer.startElement(HtmlElements.HEAD);
            writer.startElement(HtmlElements.META);
            writer.writeAttribute(HtmlAttributes.HTTP_EQUIV, "Content-Type", false);
            writer.writeAttribute(HtmlAttributes.CONTENT, contentType, false);
            writer.endElement(HtmlElements.META);
            writer.startElement(HtmlElements.META);
            writer.writeAttribute(HtmlAttributes.NAME, "viewport", false);
            writer.writeAttribute(HtmlAttributes.CONTENT, "width=device-width, initial-scale=1.0", false);
            writer.endElement(HtmlElements.META);
            writer.startElement(HtmlElements.TITLE);
            writer.writeText(title != null ? title : "");
            writer.endElement(HtmlElements.TITLE);
            for (String styleFile : theme.getStyleResources(productionMode)) {
                this.writeStyle(writer, contextPath + styleFile);
            }
            for (String styleFile : FacesContextUtils.getStyleFiles(facesContext)) {
                this.writeStyle(writer, styleFile);
            }
            if (!productionMode) {
                this.checkDuplicates(theme.getStyleResources(productionMode), FacesContextUtils.getStyleFiles(facesContext));
            }
            if ((icon = page.getApplicationIcon()) != null) {
                writer.startElement(HtmlElements.LINK);
                if (icon.endsWith(".ico")) {
                    writer.writeAttribute(HtmlAttributes.REL, "shortcut icon", false);
                    writer.writeAttribute(HtmlAttributes.HREF, icon, true);
                } else {
                    writer.writeAttribute(HtmlAttributes.REL, "icon", false);
                    writer.writeAttribute(HtmlAttributes.TYPE, MimeTypeUtils.getMimeTypeForFile(icon), true);
                    writer.writeAttribute(HtmlAttributes.HREF, icon, true);
                }
                writer.endElement(HtmlElements.LINK);
            }
            List componentResources = viewRoot.getComponentResources(facesContext, HEAD_TARGET);
            int childCount = componentResources.size();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)componentResources.get(i);
                if ("jsf.js".equals(child.getAttributes().get("name"))) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skip rendering resource jsf.js");
                    continue;
                }
                child.encodeAll(facesContext);
            }
            for (String scriptFile : theme.getScriptResources(productionMode)) {
                this.encodeScript(writer, contextPath + scriptFile);
            }
            for (String scriptFile : FacesContextUtils.getScriptFiles(facesContext)) {
                this.encodeScript(writer, scriptFile);
            }
            if (!productionMode) {
                this.checkDuplicates(theme.getScriptResources(productionMode), FacesContextUtils.getScriptFiles(facesContext));
            }
            writer.endElement(HtmlElements.HEAD);
        }
        writer.startElement(portlet ? HtmlElements.DIV : HtmlElements.BODY);
        writer.writeClassAttribute(portlet ? Classes.create((UIComponent)page, Markup.PORTLET) : Classes.create((UIComponent)page), BootstrapClass.CONTAINER_FLUID, spread, page.getCustomClass());
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)page);
        writer.writeStyleAttribute(page.getStyle());
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, page)));
        writer.startElement(HtmlElements.FORM);
        writer.writeClassAttribute(preventFrameAttacks && !facesContext.getPartialViewContext().isAjaxRequest() ? Classes.create((UIComponent)page, "preventFrameAttacks", Markup.NULL) : null, spread);
        writer.writeAttribute(HtmlAttributes.ACTION, formAction, true);
        if (partialAction != null) {
            writer.writeAttribute(DataAttributes.PARTIAL_ACTION, partialAction, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("partial action = " + partialAction);
        }
        writer.writeIdAttribute(page.getFormId(facesContext));
        writer.writeAttribute(HtmlAttributes.METHOD, this.getMethod(page), false);
        String enctype = FacesContextUtils.getEnctype(facesContext);
        if (enctype != null) {
            writer.writeAttribute(HtmlAttributes.ENCTYPE, enctype, false);
        }
        writer.writeAttribute(HtmlAttributes.ACCEPT_CHARSET, "utf-8", false);
        writer.writeAttribute(DataAttributes.CONTEXT_PATH, contextPath, true);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute("javax.faces.source");
        writer.writeIdAttribute("javax.faces.source");
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(clientId + "::" + LAST_FOCUS_ID);
        writer.writeIdAttribute(clientId + "::" + LAST_FOCUS_ID);
        writer.writeAttribute(HtmlAttributes.VALUE, FacesContextUtils.getFocusId(facesContext), true);
        writer.endElement(HtmlElements.INPUT);
        if (TobagoConfig.getInstance(FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            Secret.encode(facesContext, writer);
        }
        if (component.getFacet("backButtonDetector") != null) {
            UIComponent hidden = component.getFacet("backButtonDetector");
            RenderUtils.encode(facesContext, hidden);
        }
    }

    private void checkDuplicates(String[] resources, Collection<String> files) {
        for (String resource : resources) {
            if (!files.contains(resource)) continue;
            throw new RuntimeException("The resource '" + resource + "' will be included twice! The resource is in the theme list, and explicit in the page. Please remove it from the page!");
        }
    }

    private void writeStyle(TobagoResponseWriter writer, String style) throws IOException {
        writer.startElement(HtmlElements.LINK);
        writer.writeAttribute(HtmlAttributes.REL, "stylesheet", false);
        writer.writeAttribute(HtmlAttributes.HREF, style, true);
        writer.writeAttribute(HtmlAttributes.TYPE, "text/css", false);
        writer.endElement(HtmlElements.LINK);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIPage page = (UIPage)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = page.getClientId(facesContext);
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.PAGE__MENU_STORE);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(clientId + "::" + "jsf-state-container");
        writer.flush();
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            viewHandler.writeState(facesContext);
        }
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.FORM);
        writer.startElement(HtmlElements.NOSCRIPT);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(Classes.create((UIComponent)page, "noscript"));
        writer.writeText(TobagoResourceBundle.getString(facesContext, "pageNoscript"));
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.NOSCRIPT);
        Object response = facesContext.getExternalContext().getResponse();
        if (PortletUtils.isPortletApiAvailable() && response instanceof MimeResponse) {
            writer.endElement(HtmlElements.DIV);
        } else {
            writer.endElement(HtmlElements.BODY);
            writer.endElement(HtmlElements.HTML);
        }
        AccessKeyLogger.logStatus(facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().get("X") != null) {
            throw new RuntimeException("Debugging activated via X parameter");
        }
    }

    private void encodeScript(TobagoResponseWriter writer, String script) throws IOException {
        writer.startElement(HtmlElements.SCRIPT);
        writer.writeAttribute(HtmlAttributes.SRC, script, true);
        writer.writeAttribute(HtmlAttributes.TYPE, "text/javascript", false);
        writer.endElement(HtmlElements.SCRIPT);
    }

    private String getMethod(UIPage page) {
        return ComponentUtils.getStringAttribute((UIComponent)page, Attributes.method, "post");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

