/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class OutRenderer
extends LabelLayoutRendererBase {
    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIOut out = (AbstractUIOut)component;
        String text = RenderUtils.currentValue((UIComponent)out);
        if (text == null) {
            text = "";
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean escape = out.isEscape();
        boolean keepLineBreaks = out.isKeepLineBreaks();
        boolean createSpan = out.isCreateSpan();
        if (createSpan) {
            writer.startElement(HtmlElements.SPAN);
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)out);
            writer.writeStyleAttribute(out.getStyle());
            writer.writeClassAttribute(Classes.create((UIComponent)out), BootstrapClass.FORM_CONTROL_STATIC, out.getCustomClass());
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)out);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
        }
        if (escape) {
            if (keepLineBreaks) {
                StringTokenizer tokenizer = new StringTokenizer(text, "\r\n");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    writer.writeText(token);
                    if (!tokenizer.hasMoreTokens()) continue;
                    writer.startElement(HtmlElements.BR);
                    writer.endElement(HtmlElements.BR);
                }
            } else {
                writer.writeText(text);
            }
        } else {
            writer.writeText("", null);
            if (SanitizeMode.auto == out.getSanitize()) {
                Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                text = sanitizer.sanitize(text);
            }
            writer.write(text);
        }
    }

    @Override
    public void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        UIOut out = (UIOut)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean createSpan = out.isCreateSpan();
        if (createSpan) {
            writer.endElement(HtmlElements.SPAN);
        }
    }
}

