/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIMessages;
import org.apache.myfaces.tobago.internal.component.AbstractUIMessages;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        List<AbstractUIMessages.Item> messageList;
        UIMessages messages = (UIMessages)component;
        if (messages.isConfirmation()) {
            LOG.warn("'confirmation' is currently not supported for tc:messages!");
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("facesContext is " + facesContext.getClass().getName());
        }
        if ((messageList = messages.createMessageList(facesContext)).size() > 0) {
            writer.writeStyleAttribute(messages.getStyle());
            writer.startElement(HtmlElements.DIV);
            writer.writeIdAttribute(messages.getClientId(facesContext));
            writer.writeClassAttribute(Classes.create((UIComponent)messages), messages.getCustomClass());
            FacesMessage.Severity lastSeverity = null;
            boolean first = true;
            for (AbstractUIMessages.Item item : messageList) {
                FacesMessage message = item.getFacesMessage();
                FacesMessage.Severity severity = message.getSeverity();
                if (!first && lastSeverity != severity) {
                    writer.endElement(HtmlElements.DIV);
                }
                if (first || lastSeverity != severity) {
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.ALERT, BootstrapClass.ALERT_DISMISSIBLE, BootstrapClass.alert(severity));
                    HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)messages);
                    writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.ALERT.toString(), false);
                    writer.startElement(HtmlElements.BUTTON);
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
                    writer.writeClassAttribute(BootstrapClass.CLOSE);
                    writer.writeAttribute(DataAttributes.DISMISS, "alert", false);
                    writer.writeAttribute(Arias.ACTIVEDESCENDANT, "Close", false);
                    writer.startElement(HtmlElements.SPAN);
                    writer.writeAttribute(Arias.HIDDEN, Boolean.TRUE.toString(), false);
                    writer.writeText("\u00d7");
                    writer.endElement(HtmlElements.SPAN);
                    writer.endElement(HtmlElements.BUTTON);
                }
                this.encodeMessage(writer, messages, message, item.getClientId());
                lastSeverity = severity;
                first = false;
            }
            writer.endElement(HtmlElements.DIV);
            writer.endElement(HtmlElements.DIV);
            if (messages.getFor() == null) {
                String id = messages.getClientId(facesContext) + "::" + "messagesExists";
                writer.startElement(HtmlElements.INPUT);
                writer.writeAttribute(HtmlAttributes.VALUE, Boolean.TRUE.toString(), false);
                writer.writeAttribute(HtmlAttributes.ID, id, false);
                writer.writeAttribute(HtmlAttributes.NAME, id, false);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
                writer.endElement(HtmlElements.INPUT);
            }
        }
    }

    private void encodeMessage(TobagoResponseWriter writer, UIMessages messages, FacesMessage message, String clientId) throws IOException {
        String summary = message.getSummary();
        String detail = message.getDetail();
        writer.startElement(HtmlElements.LABEL);
        if (clientId != null) {
            writer.writeAttribute(HtmlAttributes.FOR, clientId, false);
        }
        writer.writeAttribute(HtmlAttributes.TITLE, detail, true);
        boolean writeEmptyText = true;
        if (summary != null && messages.isShowSummary()) {
            writer.writeText(summary);
            writeEmptyText = false;
            if (detail != null && messages.isShowDetail()) {
                writer.writeText(" ");
            }
        }
        if (detail != null && messages.isShowDetail()) {
            writeEmptyText = false;
            writer.writeText(detail);
        }
        if (writeEmptyText) {
            writer.writeText("");
        }
        writer.endElement(HtmlElements.LABEL);
        message.rendered();
    }
}

