/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIImage;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.FontAwesomeIconEncoder;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ImageRenderer
extends RendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUIImage image = (AbstractUIImage)component;
        String value = image.getUrl();
        boolean fontAwesome = StringUtils.startsWith(value, "fa-");
        if (fontAwesome) {
            writer.writeIcon(null, image.getStyle(), FontAwesomeIconEncoder.generateClass(value));
        } else {
            String alt = image.getAlt();
            writer.startElement(HtmlElements.IMG);
            writer.writeIdAttribute(image.getClientId(facesContext));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)image);
            writer.writeAttribute(HtmlAttributes.SRC, value, true);
            writer.writeAttribute(HtmlAttributes.ALT, alt != null ? alt : "", true);
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)image);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
            writer.writeClassAttribute(Classes.create((UIComponent)image), this.isDisabled(image) ? BootstrapClass.DISABLED : null, image.getCustomClass());
            writer.writeStyleAttribute(image.getStyle());
            writer.endElement(HtmlElements.IMG);
        }
    }

    private boolean isDisabled(AbstractUIImage image) {
        return image.isDisabled() || image.getParent() instanceof AbstractUICommandBase && ((AbstractUICommandBase)image.getParent()).isDisabled();
    }
}

