/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUIFigure;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class FigureRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIFigure figure = (AbstractUIFigure)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.FIGURE);
        writer.writeClassAttribute(Classes.create((UIComponent)figure), BootstrapClass.FIGURE, figure.getCustomClass());
        writer.writeStyleAttribute(figure.getStyle());
        String tip = figure.getTip();
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.FIGURE_IMG);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIFigure figure = (AbstractUIFigure)component;
        UIComponent label = ComponentUtils.getFacet((UIComponent)figure, Facets.label);
        String labelString = figure.getLabel();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        if (labelString != null || label != null) {
            writer.startElement(HtmlElements.FIGCAPTION);
            writer.writeClassAttribute(BootstrapClass.FIGURE_CAPTION);
            if (labelString != null) {
                writer.writeText(labelString);
            }
            if (label != null) {
                RenderUtils.encode(facesContext, label);
            }
            writer.endElement(HtmlElements.FIGCAPTION);
        }
        writer.endElement(HtmlElements.FIGURE);
    }
}

