/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.component.AbstractUIButton;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingCommandRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandRendererBase
extends DecodingCommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRendererBase.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUICommand command = (AbstractUICommand)component;
        String clientId = command.getClientId(facesContext);
        boolean disabled = command.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey(command);
        boolean link = command.getLink() != null && !disabled;
        String target = command.getTarget();
        boolean parentOfCommands = command.isParentOfCommands();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (parentOfCommands) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeIdAttribute(clientId);
            if (component instanceof AbstractUIButton) {
                writer.writeClassAttribute(BootstrapClass.BTN_GROUP);
            } else {
                writer.writeClassAttribute(BootstrapClass.DROPDOWN);
            }
        }
        if (link) {
            writer.startElement(HtmlElements.A);
        } else {
            writer.startElement(HtmlElements.BUTTON);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        }
        writer.writeIdAttribute(command.getFieldId(facesContext));
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        if (!disabled) {
            int tabIndex;
            if (link) {
                String href = RenderUtils.generateUrl(facesContext, command);
                writer.writeAttribute(HtmlAttributes.HREF, href, true);
                writer.writeAttribute(HtmlAttributes.TARGET, target, true);
                command.setOmit(true);
            }
            writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, command)));
            if (label.getAccessKey() != null) {
                writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
                AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), clientId);
            }
            if ((tabIndex = ComponentUtils.getIntAttribute((UIComponent)command, Attributes.tabIndex)) != 0) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, tabIndex);
            }
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)command);
        writer.writeStyleAttribute(command.getStyle());
        ArrayList<CssItem> cssItems = new ArrayList<CssItem>();
        if (parentOfCommands) {
            cssItems.add(BootstrapClass.DROPDOWN_TOGGLE);
            writer.writeAttribute(DataAttributes.TOGGLE, "dropdown", false);
        }
        this.addCssItems(facesContext, command, cssItems);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)command);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        cssItems.add(command.getCustomClass());
        writer.writeClassAttribute(Classes.create((UIComponent)command), null, cssItems.toArray(new CssItem[cssItems.size()]));
        boolean defaultCommand = ComponentUtils.getBooleanAttribute((UIComponent)command, Attributes.defaultCommand);
        if (defaultCommand) {
            AbstractUIFormBase form = ComponentUtils.findAncestor((UIComponent)command, AbstractUIFormBase.class);
            writer.writeAttribute(DataAttributes.DEFAULT, form.getClientId(facesContext), false);
        }
        String image = ComponentUtils.getStringAttribute((UIComponent)command, Attributes.image);
        HtmlRendererUtils.encodeIconWithLabel(writer, facesContext, image, label, disabled);
        if (link) {
            writer.endElement(HtmlElements.A);
        } else {
            writer.endElement(HtmlElements.BUTTON);
        }
        if (parentOfCommands) {
            writer.startElement(HtmlElements.UL);
            writer.writeClassAttribute(BootstrapClass.DROPDOWN_MENU);
            writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.MENU.toString(), false);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUICommand command = (AbstractUICommand)component;
        if (command.isParentOfCommands()) {
            TobagoResponseWriter writer = this.getResponseWriter(facesContext);
            for (UIComponent child : component.getChildren()) {
                BootstrapClass disabled;
                TobagoClass submenu;
                if (!child.isRendered()) continue;
                writer.startElement(HtmlElements.LI);
                if (child instanceof AbstractUICommand) {
                    AbstractUICommand c = (AbstractUICommand)child;
                    submenu = c.isParentOfCommands() ? TobagoClass.DROPDOWN__SUBMENU : null;
                    disabled = c.isDisabled() ? BootstrapClass.DISABLED : null;
                } else {
                    submenu = null;
                    disabled = null;
                }
                writer.writeClassAttribute(BootstrapClass.DROPDOWN_ITEM, submenu, disabled);
                child.encodeAll(facesContext);
                writer.endElement(HtmlElements.LI);
            }
        } else {
            super.encodeChildren(facesContext, component);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUICommand command = (AbstractUICommand)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (command.isParentOfCommands()) {
            writer.endElement(HtmlElements.UL);
            writer.endElement(HtmlElements.SPAN);
        }
    }

    protected void addCssItems(FacesContext facesContext, AbstractUICommand command, List<CssItem> collected) {
    }
}

