/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.sanitizer.IgnoringSanitizer;
import org.apache.myfaces.tobago.sanitizer.JsoupSanitizer;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoConfigSorter
implements Comparator<TobagoConfigFragment> {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigSorter.class);
    private List<TobagoConfigFragment> list;
    private List<Pair> pairs;

    public TobagoConfigSorter(List<TobagoConfigFragment> list) {
        this.list = list;
    }

    public void sort() {
        this.createRelevantPairs();
        this.makeTransitive();
        this.ensureIrreflexive();
        this.ensureAntiSymmetric();
        this.sort0();
        if (LOG.isInfoEnabled()) {
            LOG.info("Order of the Tobago config files:");
            for (TobagoConfigFragment fragment : this.list) {
                String name = fragment.getName();
                name = name == null ? "<unnamed>" : "'" + name + "'";
                LOG.info("name=" + name + " url='" + fragment.getUrl() + "'");
            }
        }
    }

    public TobagoConfigImpl merge() {
        TobagoConfigImpl result = new TobagoConfigImpl();
        String sanitizerClass = JsoupSanitizer.class.getName();
        Properties sanitizerProperties = new Properties();
        sanitizerProperties.setProperty("whitelist", "relaxed");
        for (TobagoConfigFragment fragment : this.list) {
            String defaultTheme = fragment.getDefaultThemeName();
            if (defaultTheme != null) {
                result.setDefaultThemeName(defaultTheme);
            }
            for (String supported : fragment.getSupportedThemeNames()) {
                result.addSupportedThemeName(supported);
            }
            if (fragment.getRenderersConfig() != null) {
                if (result.getRenderersConfig() instanceof RenderersConfigImpl) {
                    ((RenderersConfigImpl)result.getRenderersConfig()).merge(fragment.getRenderersConfig(), false);
                } else if (result.getRenderersConfig() == null) {
                    result.setRenderersConfig(fragment.getRenderersConfig());
                }
            }
            if (fragment.getCreateSessionSecret() != null) {
                result.setCreateSessionSecret(fragment.getCreateSessionSecret());
            }
            if (fragment.getCheckSessionSecret() != null) {
                result.setCheckSessionSecret(fragment.getCheckSessionSecret());
            }
            if (fragment.getPreventFrameAttacks() != null) {
                result.setPreventFrameAttacks(fragment.getPreventFrameAttacks());
            }
            if (fragment.getContentSecurityPolicy() != null) {
                result.getContentSecurityPolicy().merge(fragment.getContentSecurityPolicy());
            }
            if (fragment.getSetNosniffHeader() != null) {
                result.setSetNosniffHeader(fragment.getSetNosniffHeader());
            }
            if (fragment.getSanitizerClass() != null) {
                sanitizerClass = fragment.getSanitizerClass();
                sanitizerProperties = fragment.getSanitizerProperties();
            }
            result.toString();
            for (ThemeImpl theme : fragment.getThemeDefinitions()) {
                result.addAvailableTheme(theme);
            }
            Map<String, String> mimeTypes = result.getMimeTypes();
            for (Map.Entry<String, String> entry : fragment.getMimeTypes().entrySet()) {
                mimeTypes.put(entry.getKey(), entry.getValue());
            }
        }
        this.resolveThemes(result, result.getAvailableThemes());
        if (sanitizerClass != null) {
            try {
                Class<Sanitizer> aClass = Class.forName(sanitizerClass).asSubclass(Sanitizer.class);
                Sanitizer sanitizer = aClass.newInstance();
                sanitizer.setProperties(sanitizerProperties);
                result.setSanitizer(sanitizer);
            }
            catch (Throwable e) {
                LOG.error("Can't create sanitizer: '" + sanitizerClass + "'", e);
                result.setSanitizer(new IgnoringSanitizer());
            }
        }
        return result;
    }

    protected void makeTransitive() {
        boolean growing = true;
        while (growing) {
            growing = false;
            for (int i = 0; i < this.pairs.size(); ++i) {
                for (int j = 0; j < this.pairs.size(); ++j) {
                    if (this.pairs.get(i).getHigher() != this.pairs.get(j).getLower() || this.isInRelation(this.pairs.get(i).getLower(), this.pairs.get(j).getHigher())) continue;
                    this.pairs.add(new Pair(this.pairs.get(i).getLower(), this.pairs.get(j).getHigher()));
                    growing = true;
                }
            }
        }
    }

    protected void ensureIrreflexive() {
        for (Pair a : this.pairs) {
            if (a.getLower() != a.getHigher()) continue;
            StringBuilder buffer = new StringBuilder();
            buffer.append("Ordering problem. There are conflicting order rules. Not irreflexive. '");
            buffer.append(a.getLower());
            buffer.append("' < '");
            buffer.append(a.getHigher());
            buffer.append("'!\nThe reason may be a cycle.\n");
            buffer.append("Complete list of rules: \n");
            for (Pair pair : this.pairs) {
                buffer.append("'");
                buffer.append(pair.getLower());
                buffer.append("' < '");
                buffer.append(pair.getHigher());
                buffer.append("'\n");
            }
            throw new RuntimeException(buffer.toString());
        }
    }

    protected void ensureAntiSymmetric() {
        for (Pair a : this.pairs) {
            for (Pair b : this.pairs) {
                if (a.getLower() != b.getHigher() || a.getHigher() != b.getLower()) continue;
                StringBuilder buffer = new StringBuilder();
                buffer.append("Ordering problem. There are conflicting order rules. Not antisymmetric. '");
                buffer.append(a.getLower());
                buffer.append("' < '");
                buffer.append(a.getHigher());
                buffer.append("''");
                buffer.append(a.getLower());
                buffer.append("' > '");
                buffer.append(a.getHigher());
                buffer.append("'!\nThe reason may be a cycle.\n");
                buffer.append("Complete list of rules: \n");
                for (Pair pair : this.pairs) {
                    buffer.append("'");
                    buffer.append(pair.getLower());
                    buffer.append("' < '");
                    buffer.append(pair.getHigher());
                    buffer.append("'\n");
                }
                throw new RuntimeException(buffer.toString());
            }
        }
    }

    @Override
    public int compare(TobagoConfigFragment a, TobagoConfigFragment b) {
        if (this.isInRelation(a, b)) {
            return -1;
        }
        if (this.isInRelation(b, a)) {
            return 1;
        }
        return 0;
    }

    protected void createRelevantPairs() {
        this.pairs = new ArrayList<Pair>();
        for (TobagoConfigFragment tobagoConfig : this.list) {
            for (String befores : tobagoConfig.getBefore()) {
                TobagoConfigFragment before = this.findByName(befores);
                if (before == null) continue;
                this.pairs.add(new Pair(tobagoConfig, before));
            }
            for (String afters : tobagoConfig.getAfter()) {
                TobagoConfigFragment after = this.findByName(afters);
                if (after == null) continue;
                this.pairs.add(new Pair(after, tobagoConfig));
            }
        }
    }

    protected void sort0() {
        Collections.sort(this.list, this);
    }

    private boolean isInRelation(TobagoConfigFragment lower, TobagoConfigFragment higher) {
        for (Pair p : this.pairs) {
            if (p.getLower() != lower || p.getHigher() != higher) continue;
            return true;
        }
        return false;
    }

    private TobagoConfigFragment findByName(String name) {
        for (TobagoConfigFragment tobagoConfig : this.list) {
            if (!name.equals(tobagoConfig.getName())) continue;
            return tobagoConfig;
        }
        return null;
    }

    private void resolveThemes(TobagoConfigImpl tobagoConfig, Map<String, ThemeImpl> map) {
        for (ThemeImpl theme : map.values()) {
            String fallbackName = theme.getFallbackName();
            ThemeImpl fallback = map.get(fallbackName);
            theme.setFallback(fallback);
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveFallbacks();
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveRendererConfig(tobagoConfig.getRenderersConfig());
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveResources();
        }
        for (ThemeImpl theme : map.values()) {
            theme.init();
        }
    }

    protected List<Pair> getPairs() {
        return this.pairs;
    }

    private static class Pair {
        private final TobagoConfigFragment lower;
        private final TobagoConfigFragment higher;

        private Pair(TobagoConfigFragment lower, TobagoConfigFragment higher) {
            this.lower = lower;
            this.higher = higher;
        }

        public TobagoConfigFragment getLower() {
            return this.lower;
        }

        public TobagoConfigFragment getHigher() {
            return this.higher;
        }

        public String toString() {
            return this.lower + "<" + this.higher;
        }
    }
}

