/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUISection
extends AbstractUICollapsiblePanel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUISection.class);
    private int level;

    public String getLabelToRender() {
        UIComponent facet = ComponentUtils.getFacet((UIComponent)this, Facets.label);
        if (facet instanceof UIOutput) {
            return String.valueOf(((UIOutput)facet).getValue());
        }
        if (facet != null) {
            LOG.warn("Wrong type: " + facet.getClass().getName());
        }
        return this.getLabel();
    }

    public abstract String getLabel();

    public abstract String getImage();

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getLevel() == 0) {
            AbstractUISection section = ComponentUtils.findAncestor(this.getParent(), AbstractUISection.class);
            if (section != null) {
                this.setLevel(section.getLevel() + 1);
            } else {
                this.setLevel(1);
            }
        }
        super.encodeBegin(context);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

