/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.layout.OrderBy;

public abstract class AbstractUIMessages
extends UIMessages
implements Visual {
    public List<Item> createMessageList(FacesContext facesContext) {
        Object clientIds = this.isGlobalOnly() ? new SingletonIterator(null) : (this.getFor() != null ? new SingletonIterator((Object)this.getFor()) : facesContext.getClientIdsWithMessages());
        List<Item> messages = this.collectMessageList(facesContext, (Iterator)clientIds);
        if (OrderBy.severity == this.getOrderBy()) {
            Collections.sort(messages, new ItemComparator());
        }
        return messages;
    }

    private List<Item> collectMessageList(FacesContext facesContext, Iterator clientIds) {
        ArrayList<Item> messages = new ArrayList<Item>();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator i = facesContext.getMessages(clientId);
            while (i.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)i.next();
                if (this.getMaxNumber() != null && messages.size() >= this.getMaxNumber()) {
                    return messages;
                }
                if (facesMessage.getSeverity().getOrdinal() < this.getMinSeverity().getOrdinal() || facesMessage.getSeverity().getOrdinal() > this.getMaxSeverity().getOrdinal()) continue;
                messages.add(new Item(clientId, facesMessage));
            }
        }
        return messages;
    }

    public abstract FacesMessage.Severity getMinSeverity();

    public abstract FacesMessage.Severity getMaxSeverity();

    public abstract Integer getMaxNumber();

    public abstract OrderBy getOrderBy();

    public static class ItemComparator
    implements Comparator<Item> {
        @Override
        public int compare(Item item1, Item item2) {
            return item2.getFacesMessage().getSeverity().getOrdinal() - item1.getFacesMessage().getSeverity().getOrdinal();
        }
    }

    public static class Item {
        private String clientId;
        private FacesMessage facesMessage;

        public Item(String clientId, FacesMessage facesMessage) {
            this.clientId = clientId;
            this.facesMessage = facesMessage;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public FacesMessage getFacesMessage() {
            return this.facesMessage;
        }

        public void setFacesMessage(FacesMessage facesMessage) {
            this.facesMessage = facesMessage;
        }
    }
}

