/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.util.AjaxUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIFormBase
extends UIForm {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIFormBase.class);

    public void processDecodes(FacesContext facesContext) {
        this.decode(facesContext);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(facesContext);
        }
    }

    public void setSubmitted(boolean b) {
        super.setSubmitted(b);
        for (AbstractUIForm subForm : ComponentUtils.findSubForms((UIComponent)this)) {
            subForm.setSubmitted(b);
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processValidators for form: {}", (Object)this.getClientId(facesContext));
        }
        if (this.isSubmitted() || AjaxUtils.isAjaxRequest(facesContext)) {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processValidators(facesContext);
            }
        } else {
            for (AbstractUIForm subForm : ComponentUtils.findSubForms((UIComponent)this)) {
                subForm.processValidators(facesContext);
            }
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processUpdates for form: {}", (Object)this.getClientId(facesContext));
        }
        if (this.isSubmitted() || AjaxUtils.isAjaxRequest(facesContext)) {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processUpdates(facesContext);
            }
        } else {
            for (AbstractUIForm subForm : ComponentUtils.findSubForms((UIComponent)this)) {
                subForm.processUpdates(facesContext);
            }
        }
    }
}

