/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewExpiredException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.util.AjaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class AjaxNavigationState {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxNavigationState.class);
    private static final String SESSION_KEY = "tobago-AjaxNavigationState";
    private static final String VIEW_ROOT_KEY = "tobago-AjaxNavigationState-VIEW_ROOT_KEY";
    private UIViewRoot viewRoot;
    private Map<String, List<FacesMessage>> messages;

    private AjaxNavigationState(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.getSessionMap().put(SESSION_KEY, this);
        this.viewRoot = facesContext.getViewRoot();
        this.messages = new HashMap<String, List<FacesMessage>>();
        Iterator iterator = facesContext.getClientIdsWithMessages();
        while (iterator.hasNext()) {
            this.addFacesMessages(facesContext, (String)iterator.next());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Saved viewRoot.getViewId() = \"{}\"", (Object)this.viewRoot.getViewId());
            for (Map.Entry<String, List<FacesMessage>> entry : this.messages.entrySet()) {
                for (FacesMessage message : entry.getValue()) {
                    LOG.trace("Saved message \"{}\" : \"{}\"", (Object)entry.getKey(), (Object)message);
                }
            }
        }
    }

    private void addFacesMessages(FacesContext facesContext, String clientId) {
        Iterator facesMessages = facesContext.getMessages(clientId);
        while (facesMessages.hasNext()) {
            this.addFacesMessage(clientId, (FacesMessage)facesMessages.next());
        }
    }

    private void addFacesMessage(String clientId, FacesMessage facesMessage) {
        List<FacesMessage> facesMessages = this.messages.get(clientId);
        if (facesMessages == null) {
            facesMessages = new ArrayList<FacesMessage>();
            this.messages.put(clientId, facesMessages);
        }
        facesMessages.add(facesMessage);
    }

    private void restoreView(FacesContext facesContext) {
        facesContext.setViewRoot(this.viewRoot);
        for (Map.Entry<String, List<FacesMessage>> entry : this.messages.entrySet()) {
            for (FacesMessage facesMessage : entry.getValue()) {
                facesContext.addMessage(entry.getKey(), facesMessage);
            }
        }
        facesContext.renderResponse();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Restored viewRoot.getViewId() = \"{}\"", (Object)this.viewRoot.getViewId());
            for (Map.Entry<String, List<FacesMessage>> entry : this.messages.entrySet()) {
                for (FacesMessage message : entry.getValue()) {
                    LOG.trace("Restored message \"{}\" : \"{}\"", (Object)entry.getKey(), (Object)message);
                }
            }
        }
    }

    public static void storeIncomingView(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (LOG.isTraceEnabled()) {
            if (viewRoot != null) {
                LOG.trace("incoming viewId = '{}'", (Object)viewRoot.getViewId());
            } else {
                LOG.trace("incoming viewRoot is null");
            }
        }
        facesContext.getExternalContext().getRequestMap().put(VIEW_ROOT_KEY, viewRoot);
    }

    public static boolean isNavigation(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("current viewId = '{}'", (Object)viewRoot.getViewId());
            }
        } else {
            LOG.warn("current viewRoot is null");
            return false;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        UIViewRoot incomingViewRoot = (UIViewRoot)requestMap.get(VIEW_ROOT_KEY);
        if (viewRoot != incomingViewRoot) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("requesting full page reload because of navigation to {} from {}", (Object)viewRoot.getViewId(), (Object)incomingViewRoot.getViewId());
            }
            return true;
        }
        return false;
    }

    public static void beforeRestoreView(FacesContext facesContext) {
        if (facesContext.getExternalContext().getSessionMap().get(SESSION_KEY) != null) {
            facesContext.setViewRoot(new UIViewRoot());
        }
    }

    public static void afterRestoreView(FacesContext facesContext) {
        ExternalContext externalContext;
        if (AjaxNavigationState.isViewExpiredExceptionThrown(facesContext)) {
            try {
                facesContext.getExceptionHandler().handle();
            }
            catch (ViewExpiredException e) {
                LOG.debug("Caught: " + e.getMessage(), (Throwable)e);
                try {
                    ExternalContext externalContext2 = facesContext.getExternalContext();
                    String url = externalContext2.getRequestContextPath() + externalContext2.getRequestServletPath() + externalContext2.getRequestPathInfo();
                    AjaxInternalUtils.redirect(facesContext, url);
                    facesContext.responseComplete();
                }
                catch (IOException e1) {
                    LOG.error("Caught: " + e1.getMessage(), (Throwable)e);
                }
            }
        }
        if ((externalContext = facesContext.getExternalContext()).getSessionMap().get(SESSION_KEY) == null) {
            AjaxNavigationState.storeIncomingView(facesContext);
        } else {
            AjaxNavigationState navigationState = (AjaxNavigationState)externalContext.getSessionMap().remove(SESSION_KEY);
            navigationState.restoreView(facesContext);
            LOG.trace("force render requested navigation view");
        }
    }

    private static boolean isViewExpiredExceptionThrown(FacesContext facesContext) {
        Throwable throwable;
        Iterator eventIterator = facesContext.getExceptionHandler().getUnhandledExceptionQueuedEvents().iterator();
        return eventIterator.hasNext() && (throwable = ((ExceptionQueuedEvent)eventIterator.next()).getContext().getException()) instanceof ViewExpiredException;
    }

    public static void afterInvokeApplication(FacesContext facesContext) {
        if (AjaxUtils.isAjaxRequest(facesContext) && AjaxNavigationState.isNavigation(facesContext)) {
            try {
                facesContext.getExternalContext().getSessionMap().put(SESSION_KEY, new AjaxNavigationState(facesContext));
                AjaxInternalUtils.requestNavigationReload(facesContext);
            }
            catch (IOException e) {
                LOG.error("Caught: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

