/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import java.util.HashSet;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import org.apache.myfaces.tobago.component.InputSuggest;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.event.SheetStateChangeSource;
import org.apache.myfaces.tobago.event.SortActionSource;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.facelets.SegmentLayoutRule;
import org.apache.myfaces.tobago.facelets.SheetStateChangeSourceRule;
import org.apache.myfaces.tobago.facelets.SortActionSourceRule;
import org.apache.myfaces.tobago.facelets.SuggestMethodRule;
import org.apache.myfaces.tobago.facelets.SupportsMarkupRule;
import org.apache.myfaces.tobago.facelets.TabChangeSourceRule;
import org.apache.myfaces.tobago.internal.component.AbstractUISegmentLayout;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;

public class TobagoComponentHandler
extends ComponentHandler {
    public TobagoComponentHandler(ComponentConfig componentConfig) {
        super(componentConfig);
    }

    protected MetaRuleset createMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        if (SortActionSource.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SortActionSourceRule.INSTANCE);
        }
        if (AbstractUISegmentLayout.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SegmentLayoutRule.INSTANCE);
        }
        if (TabChangeSource.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)TabChangeSourceRule.INSTANCE);
        }
        if (SheetStateChangeSource.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SheetStateChangeSourceRule.INSTANCE);
        }
        if (Visual.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SupportsMarkupRule.INSTANCE);
        }
        if (InputSuggest.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SuggestMethodRule.INSTANCE);
        }
        return metaRuleset;
    }

    public void onComponentPopulated(FaceletContext context, UIComponent component, UIComponent parent) {
        if (component instanceof EditableValueHolder) {
            this.addDefaultValidators(context.getFacesContext(), (EditableValueHolder)component);
        }
    }

    private void addDefaultValidators(FacesContext context, EditableValueHolder component) {
        TobagoConfigImpl tobagoConfig = (TobagoConfigImpl)TobagoConfig.getInstance(context);
        Map<String, String> validatorInfoMap = tobagoConfig.getDefaultValidatorInfo();
        if (validatorInfoMap.isEmpty()) {
            return;
        }
        Validator[] validators = component.getValidators();
        if (validators.length > 0) {
            HashSet<String> classNames = new HashSet<String>();
            for (Validator validator : validators) {
                classNames.add(validator.getClass().getName());
            }
            for (Map.Entry entry : validatorInfoMap.entrySet()) {
                if (classNames.contains(entry.getValue())) continue;
                component.addValidator(context.getApplication().createValidator((String)entry.getKey()));
            }
        } else {
            for (String next : validatorInfoMap.keySet()) {
                component.addValidator(context.getApplication().createValidator(next));
            }
        }
    }
}

