/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.UISegmentLayout;
import org.apache.myfaces.tobago.layout.ColumnPartition;

public class SegmentLayoutRule
extends MetaRule {
    public static final SegmentLayoutRule INSTANCE = new SegmentLayoutRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget metadataTarget) {
        if (metadataTarget.isTargetInstanceOf(UISegmentLayout.class) && attribute.isLiteral()) {
            Attributes a = Attributes.valueOfFailsafe(name);
            if (Attributes.extraSmall == a) {
                return new ExtraSmallMapper(attribute);
            }
            if (Attributes.small == a) {
                return new SmallMapper(attribute);
            }
            if (Attributes.medium == a) {
                return new MediumMapper(attribute);
            }
            if (Attributes.large == a) {
                return new LargeMapper(attribute);
            }
        }
        return null;
    }

    static final class LargeMapper
    extends Metadata {
        private final TagAttribute attribute;

        LargeMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UISegmentLayout gridLayout = (UISegmentLayout)instance;
            gridLayout.setLarge(ColumnPartition.valueOf(this.attribute.getValue()));
        }
    }

    static final class MediumMapper
    extends Metadata {
        private final TagAttribute attribute;

        MediumMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UISegmentLayout gridLayout = (UISegmentLayout)instance;
            gridLayout.setMedium(ColumnPartition.valueOf(this.attribute.getValue()));
        }
    }

    static final class SmallMapper
    extends Metadata {
        private final TagAttribute attribute;

        SmallMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UISegmentLayout gridLayout = (UISegmentLayout)instance;
            gridLayout.setSmall(ColumnPartition.valueOf(this.attribute.getValue()));
        }
    }

    static final class ExtraSmallMapper
    extends Metadata {
        private final TagAttribute attribute;

        ExtraSmallMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UISegmentLayout gridLayout = (UISegmentLayout)instance;
            gridLayout.setExtraSmall(ColumnPartition.valueOf(this.attribute.getValue()));
        }
    }
}

