/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagException;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.component.UIEvent;
import org.apache.myfaces.tobago.facelets.TobagoComponentHandler;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;

public class EventHandler
extends TobagoComponentHandler
implements BehaviorHolderAttachedObjectHandler {
    public static final Class<?>[] AJAX_BEHAVIOR_LISTENER_SIG = new Class[]{AjaxBehaviorEvent.class};
    private final TagAttribute event = this.getAttribute(Attributes.event.getName());

    public EventHandler(ComponentConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        super.apply(ctx, parent);
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (!(parent instanceof ClientBehaviorHolder)) {
            throw new TagException(this.tag, "Parent is not composite component or of type ClientBehaviorHolder, type is: " + parent);
        }
        this.applyAttachedObject(ctx.getFacesContext(), parent);
    }

    public String getEventName() {
        if (this.event == null) {
            return null;
        }
        return this.event.getValue();
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        Map clientBehaviors;
        List clientBehaviorList;
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        ClientBehaviorHolder cvh = (ClientBehaviorHolder)parent;
        String eventName = this.getEventName();
        if (eventName == null) {
            eventName = cvh.getDefaultEventName();
            if (eventName == null) {
                throw new TagAttributeException(this.event, "eventName could not be defined for f:ajax tag with no wrap mode.");
            }
        } else if (!cvh.getEventNames().contains(eventName)) {
            throw new TagAttributeException(this.event, "event it is not a valid eventName defined for this component");
        }
        if ((clientBehaviorList = (List)(clientBehaviors = cvh.getClientBehaviors()).get(eventName)) != null && !clientBehaviorList.isEmpty()) {
            for (ClientBehavior cb : clientBehaviorList) {
                if (!(cb instanceof AjaxBehavior)) continue;
                return;
            }
        }
        EventBehavior ajaxBehavior = this.createBehavior(context);
        cvh.addClientBehavior(eventName, (ClientBehavior)ajaxBehavior);
    }

    protected EventBehavior createBehavior(FacesContext context) {
        return (EventBehavior)context.getApplication().createBehavior("org.apache.myfaces.tobago.behavior.Event");
    }

    public void onComponentCreated(FaceletContext faceletContext, UIComponent component, UIComponent parent) {
        super.onComponentCreated(faceletContext, component, parent);
        UIEvent event = (UIEvent)component;
        if (event.getEvent() == null) {
            ClientBehaviorHolder cvh = (ClientBehaviorHolder)parent;
            event.setEvent(ClientBehaviors.valueOf(cvh.getDefaultEventName()));
        }
    }

    public String getFor() {
        return null;
    }

    public static final class AjaxBehaviorListenerImpl
    implements AjaxBehaviorListener,
    PartialStateHolder {
        private MethodExpression expression;
        private boolean transientBoolean;
        private boolean initialStateMarked;

        public AjaxBehaviorListenerImpl() {
        }

        public AjaxBehaviorListenerImpl(MethodExpression expr) {
            this.expression = expr;
        }

        public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
            this.expression.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
        }

        public boolean isTransient() {
            return this.transientBoolean;
        }

        public void restoreState(FacesContext context, Object state) {
            if (state == null) {
                return;
            }
            this.expression = (MethodExpression)state;
        }

        public Object saveState(FacesContext context) {
            if (this.initialStateMarked()) {
                return null;
            }
            return this.expression;
        }

        public void setTransient(boolean newTransientValue) {
            this.transientBoolean = newTransientValue;
        }

        public void clearInitialState() {
            this.initialStateMarked = false;
        }

        public boolean initialStateMarked() {
            return this.initialStateMarked;
        }

        public void markInitialState() {
            this.initialStateMarked = true;
        }
    }
}

