/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TobagoBundle
extends ResourceBundle {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoBundle.class);
    private String bundleName;
    private ResourceBundle bundle;

    public TobagoBundle(String bundleName) {
        this.bundleName = bundleName;
        this.bundle = ResourceBundle.getBundle(bundleName, new XmlTobagoBundle.XMLResourceBundleControl());
    }

    @Override
    protected Object handleGetObject(String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for '{}' in bundle '{}'", (Object)key, (Object)this.bundleName);
        }
        return this.bundle.getObject(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(Collections.emptyList());
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public static class XmlTobagoBundle
    extends ResourceBundle {
        private static final String XML = "xml";
        private Properties props = new Properties();

        private XmlTobagoBundle(InputStream stream) throws IOException {
            this.props.loadFromXML(stream);
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.props.getProperty(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            Set<String> handleKeys = this.props.stringPropertyNames();
            return Collections.enumeration(handleKeys);
        }

        public static class XMLResourceBundleControl
        extends ResourceBundle.Control {
            @Override
            public List<String> getFormats(String baseName) {
                return Collections.singletonList(XmlTobagoBundle.XML);
            }

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                InputStream stream;
                if (baseName == null || locale == null || format == null || loader == null) {
                    throw new NullPointerException();
                }
                XmlTobagoBundle bundle = null;
                if (!format.equals(XmlTobagoBundle.XML)) {
                    return null;
                }
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                URL url = loader.getResource(resourceName);
                if (url == null) {
                    return null;
                }
                URLConnection connection = url.openConnection();
                if (connection == null) {
                    return null;
                }
                if (reload) {
                    connection.setUseCaches(false);
                }
                if ((stream = connection.getInputStream()) == null) {
                    return null;
                }
                BufferedInputStream bis = new BufferedInputStream(stream);
                bundle = new XmlTobagoBundle(bis);
                bis.close();
                return bundle;
            }
        }
    }
}

