/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.util.BeanComparator;
import org.apache.myfaces.tobago.util.ComparatorBase;
import org.apache.myfaces.tobago.util.ValueExpressionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sorter {
    private static final Logger LOG = LoggerFactory.getLogger(Sorter.class);
    private Comparator comparator;

    @Deprecated
    public void perform(SortActionEvent sortEvent) {
        AbstractUISheet data = (AbstractUISheet)sortEvent.getComponent();
        this.perform(data);
    }

    public void perform(AbstractUISheet data) {
        Object value = data.getValue();
        if (value instanceof DataModel) {
            value = ((DataModel)value).getWrappedData();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SheetState sheetState = data.getSheetState(facesContext);
        String sortedColumnId = sheetState.getSortedColumnId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorterId = '{}'", (Object)sortedColumnId);
        }
        if (sortedColumnId == null) {
            return;
        }
        UIColumn column = (UIColumn)data.findComponent(sortedColumnId);
        if (column == null) {
            LOG.warn("No column to sort found, sorterId = '{}'", (Object)sortedColumnId);
            return;
        }
        if (value instanceof List || value instanceof Object[]) {
            ComparatorBase actualComparator;
            block26: {
                try {
                    UIComponent child = this.getFirstSortableChild(column.getChildren());
                    if (child != null) {
                        Attributes attribute;
                        Attributes attributes = attribute = child instanceof AbstractUICommand ? Attributes.label : Attributes.value;
                        if (child.getValueExpression(attribute.getName()) != null) {
                            String var = data.getVar();
                            if (var == null) {
                                LOG.error("No sorting performed. Property var of sheet is not set!");
                                this.unsetSortableAttribute(column);
                                return;
                            }
                            String expressionString = child.getValueExpression(attribute.getName()).getExpressionString();
                            if (this.isSimpleProperty(expressionString)) {
                                if (expressionString.startsWith("#{") && expressionString.endsWith("}")) {
                                    expressionString = expressionString.substring(2, expressionString.length() - 1);
                                }
                                String sortProperty = expressionString.substring(var.length() + 1);
                                actualComparator = new BeanComparator(sortProperty, this.comparator, !sheetState.isAscending());
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Sort property is {}", (Object)sortProperty);
                                }
                            } else {
                                boolean descending = !sheetState.isAscending();
                                ValueExpression expression = child.getValueExpression("value");
                                actualComparator = new ValueExpressionComparator(facesContext, var, expression, descending, this.comparator);
                            }
                            break block26;
                        }
                        LOG.error("No sorting performed. No Expression target found for sorting!");
                        this.unsetSortableAttribute(column);
                        return;
                    }
                    LOG.error("No sorting performed. Value is not instanceof List or Object[]!");
                    this.unsetSortableAttribute(column);
                    return;
                }
                catch (Exception e) {
                    LOG.error("Error while extracting sortMethod :" + e.getMessage(), (Throwable)e);
                    if (column != null) {
                        this.unsetSortableAttribute(column);
                    }
                    return;
                }
            }
            ArrayList selectedDataRows = null;
            if (sheetState.getSelectedRows().size() > 0) {
                selectedDataRows = new ArrayList(sheetState.getSelectedRows().size());
                for (Integer index : sheetState.getSelectedRows()) {
                    Object dataRow = value instanceof List ? ((List)value).get(index) : ((Object[])value)[index];
                    selectedDataRows.add(dataRow);
                }
            }
            if (value instanceof List) {
                Collections.sort((List)value, actualComparator);
            } else {
                Arrays.sort((Object[])value, actualComparator);
            }
            if (selectedDataRows != null) {
                sheetState.getSelectedRows().clear();
                for (Object dataRow : selectedDataRows) {
                    int i;
                    int index = -1;
                    if (value instanceof List) {
                        for (i = 0; i < ((List)value).size() && index < 0; ++i) {
                            if (dataRow != ((List)value).get(i)) continue;
                            index = i;
                        }
                    } else {
                        for (i = 0; i < ((Object[])value).length && index < 0; ++i) {
                            if (dataRow != ((Object[])value)[i]) continue;
                            index = i;
                        }
                    }
                    if (index < 0) continue;
                    sheetState.getSelectedRows().add(index);
                }
            }
        } else {
            LOG.warn("Sorting not supported for type " + (value != null ? value.getClass().toString() : "null"));
        }
    }

    boolean isSimpleProperty(String expressionString) {
        if (expressionString.startsWith("#{") && expressionString.endsWith("}")) {
            String[] parts;
            String inner = expressionString.substring(2, expressionString.length() - 1);
            for (String part : parts = StringUtils.split(inner, '.')) {
                if (StringUtils.isAlpha(part)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void unsetSortableAttribute(UIColumn uiColumn) {
        LOG.warn("removing attribute sortable from column " + uiColumn.getId());
        uiColumn.getAttributes().put(Attributes.sortable.getName(), Boolean.FALSE);
    }

    private UIComponent getFirstSortableChild(List<UIComponent> children) {
        UIComponent result = null;
        Iterator<UIComponent> iterator = children.iterator();
        while (iterator.hasNext()) {
            UIComponent child;
            result = child = iterator.next();
            if (child instanceof UISelectMany || child instanceof UISelectOne || child instanceof UISelectBoolean || child instanceof AbstractUICommand && child.getChildren().isEmpty() || child instanceof UIInput && "Hidden".equals(child.getRendererType()) || !(child instanceof UIOutput) && (!(child instanceof UICommand) && !(child instanceof UIPanel) || !((child = this.getFirstSortableChild(child.getChildren())) instanceof UIOutput))) continue;
            break;
        }
        return result;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

