/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.sanitizer;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupSanitizer
implements Sanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(JsoupSanitizer.class);
    private Safelist safelist;
    private String safelistName;
    private boolean unmodifiable = false;

    @Override
    public String sanitize(String html) {
        String safe = Jsoup.clean((String)html, (Safelist)this.safelist);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sanitized: " + safe);
        }
        return safe;
    }

    @Override
    public void setProperties(Properties configuration) {
        this.checkLocked();
        this.unmodifiable = true;
        Enumeration<?> enumeration = configuration.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if ("whitelist".equals(key)) {
                key = "safelist";
            }
            if ("safelist".equals(key)) {
                this.safelistName = configuration.getProperty(key);
                if ("basic".equals(this.safelistName)) {
                    this.safelist = Safelist.basic();
                    continue;
                }
                if ("basicWithImages".equals(this.safelistName)) {
                    this.safelist = Safelist.basicWithImages();
                    continue;
                }
                if ("none".equals(this.safelistName)) {
                    this.safelist = Safelist.none();
                    continue;
                }
                if ("relaxed".equals(this.safelistName)) {
                    this.safelist = Safelist.relaxed();
                    continue;
                }
                if ("simpleText".equals(this.safelistName)) {
                    this.safelist = Safelist.simpleText();
                    continue;
                }
                throw new RuntimeException("Unknown configuration value for 'safelist' in tobago-config.xml found! value='" + this.safelistName + "'");
            }
            throw new RuntimeException("Unknown configuration key in tobago-config.xml found! key='" + key + "'");
        }
        if (LOG.isInfoEnabled()) {
            LOG.warn("Using safelist '" + this.safelistName + "' for sanitizing!");
        }
    }

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new RuntimeException("The configuration must not be changed after initialization!");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " safelist='" + this.safelistName + "'";
    }
}

