/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.myfaces.tobago.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePath
implements Serializable {
    private final int[] path;

    public TreePath(int ... path) {
        this.path = path;
    }

    public TreePath(List<Integer> pathList) {
        this.path = new int[pathList.size()];
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = pathList.get(i);
        }
    }

    @Deprecated
    public TreePath(TreePath position, int addendum) {
        this.path = new int[position.path.length + 1];
        System.arraycopy(position.path, 0, this.path, 0, position.path.length);
        this.path[position.path.length] = addendum;
    }

    @Deprecated
    public TreePath(String string) throws NumberFormatException {
        this(StringUtils.parseIntegerList(string, "_"));
    }

    public TreePath(TreeNode nodeParameter) {
        TreeNode node = nodeParameter;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        int n = 0;
        while (node != null) {
            list.add(node);
            node = node.getParent();
            ++n;
        }
        this.path = new int[n - 1];
        block1: for (int i = n - 2; i >= 0; --i) {
            TreeNode parent = (TreeNode)list.get(i + 1);
            TreeNode child = (TreeNode)list.get(i);
            for (int j = 0; j < parent.getChildCount(); ++j) {
                if (parent.getChildAt(j) != child) continue;
                this.path[n - 2 - i] = j;
                continue block1;
            }
        }
    }

    public int[] getPath() {
        return this.path;
    }

    public TreePath getParent() {
        int[] newPath = new int[this.path.length - 1];
        System.arraycopy(this.path, 0, newPath, 0, newPath.length);
        return new TreePath(newPath);
    }

    public boolean isRoot() {
        return this.path.length == 0;
    }

    public int getLength() {
        return this.path.length;
    }

    @Deprecated
    public String getPathString() {
        StringBuilder builder = new StringBuilder();
        for (int item : this.path) {
            builder.append("_");
            builder.append(item);
        }
        return builder.toString();
    }

    @Deprecated
    public String getParentPathString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.path.length - 1; ++i) {
            builder.append("_");
            builder.append(this.path[i]);
        }
        return builder.toString();
    }

    @Deprecated
    public DefaultMutableTreeNode getNode(DefaultMutableTreeNode treeParameter) {
        DefaultMutableTreeNode tree = treeParameter;
        if (tree == null) {
            return null;
        }
        for (int i = 1; i < this.path.length; ++i) {
            int pos = this.path[i];
            if (pos >= tree.getChildCount()) {
                return null;
            }
            tree = (DefaultMutableTreeNode)tree.getChildAt(pos);
        }
        return tree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePath nodeIndex = (TreePath)o;
        return Arrays.equals(this.path, nodeIndex.path);
    }

    public int hashCode() {
        return this.path != null ? Arrays.hashCode(this.path) : 0;
    }

    public String toString() {
        return Arrays.toString(this.path);
    }
}

