/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TobagoConfigSorter {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigSorter.class);
    private final List<Vertex> vertices = new ArrayList<Vertex>();

    public TobagoConfigSorter(List<TobagoConfigFragment> fragmentList) {
        for (TobagoConfigFragment tobagoConfigFragment : fragmentList) {
            this.vertices.add(new Vertex(tobagoConfigFragment));
        }
    }

    public List<TobagoConfigFragment> topologicalSort() {
        this.createEdges();
        this.checkCycles();
        ArrayList<TobagoConfigFragment> result = new ArrayList<TobagoConfigFragment>();
        for (Vertex vertex : this.vertices) {
            this.topologicalSort0(vertex, result);
        }
        this.logResult(result);
        return result;
    }

    private void topologicalSort0(Vertex vertex, List<TobagoConfigFragment> result) {
        if (vertex.isVisited()) {
            return;
        }
        vertex.setVisited(true);
        for (Vertex adjacent : vertex.getAdjacencyList()) {
            this.topologicalSort0(adjacent, result);
        }
        result.add(vertex.getFragment());
    }

    private void logResult(List<TobagoConfigFragment> result) {
        if (LOG.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("Order of the Tobago config files: ");
            for (TobagoConfigFragment fragment : result) {
                String name = fragment.getName();
                if (LOG.isDebugEnabled()) {
                    builder.append("name=");
                    if (name == null) {
                        builder.append("<unnamed>");
                    } else {
                        builder.append("'");
                        builder.append(name);
                        builder.append("'");
                    }
                    builder.append(" url='");
                    builder.append(fragment.getUrl());
                    builder.append("'");
                    continue;
                }
                builder.append(name);
                builder.append(", ");
            }
            LOG.info(builder.toString());
        }
    }

    private void createEdges() {
        for (Vertex vertex : this.vertices) {
            TobagoConfigFragment current = vertex.getFragment();
            for (String befores : current.getBefore()) {
                TobagoConfigFragment before = this.findByName(befores);
                if (before == null) continue;
                this.findVertex(before).addAdjacent(this.findVertex(current));
            }
            for (String afters : current.getAfter()) {
                TobagoConfigFragment after = this.findByName(afters);
                if (after == null) continue;
                this.findVertex(current).addAdjacent(this.findVertex(after));
            }
        }
    }

    private void checkCycles() {
        LOG.debug("Cycle detection:");
        for (Vertex vertex : this.vertices) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking reachable vertices from base {}", (Object)vertex.getFragment());
            }
            this.checkCycles0(vertex, vertex);
        }
    }

    private void checkCycles0(Vertex vertex, Vertex base) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("vertex: {}", (Object)vertex.toString());
            LOG.debug("base:   {}", (Object)base.getFragment().toString());
        }
        for (Vertex adjacent : vertex.getAdjacencyList()) {
            if (base == adjacent) {
                throw new IllegalStateException("Cycle detected name='" + vertex + "' base=" + base + "! ");
            }
            this.checkCycles0(adjacent, base);
        }
    }

    private Vertex findVertex(TobagoConfigFragment fragment) {
        for (Vertex vertex : this.vertices) {
            if (vertex.getFragment() != fragment) continue;
            return vertex;
        }
        throw new RuntimeException("Problem with sorting! This might be a bug.");
    }

    private TobagoConfigFragment findByName(String name) {
        for (Vertex vertex : this.vertices) {
            TobagoConfigFragment fragment = vertex.getFragment();
            if (!name.equals(fragment.getName())) continue;
            return fragment;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Vertex {
        private final TobagoConfigFragment fragment;
        private final List<Vertex> adjacencyList;
        private boolean visited;

        private Vertex(TobagoConfigFragment fragment) {
            this.fragment = fragment;
            this.adjacencyList = new ArrayList<Vertex>();
        }

        public boolean isVisited() {
            return this.visited;
        }

        public void setVisited(boolean visited) {
            this.visited = visited;
        }

        public TobagoConfigFragment getFragment() {
            return this.fragment;
        }

        public void addAdjacent(Vertex higher) {
            this.adjacencyList.add(higher);
        }

        public List<Vertex> getAdjacencyList() {
            return this.adjacencyList;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.fragment);
            builder.append(" -> [");
            for (Vertex vertex : this.adjacencyList) {
                builder.append(vertex.getFragment());
                builder.append(", ");
            }
            if (builder.charAt(builder.length() - 1) == ' ') {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

