/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.ajax.AjaxUtils;
import org.apache.myfaces.tobago.component.DeprecatedDimension;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.ajax.AjaxResponseRenderer;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.Box;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.model.PageStateImpl;
import org.apache.myfaces.tobago.util.ApplyRequestValuesCallback;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.apache.myfaces.tobago.util.ProcessValidationsCallback;
import org.apache.myfaces.tobago.util.TobagoCallback;
import org.apache.myfaces.tobago.util.UpdateModelValuesCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIPage
extends AbstractUIForm
implements OnComponentPopulated,
LayoutContainer,
DeprecatedDimension {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIPage.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Page";
    public static final String FORM_ACCEPT_CHARSET = "utf-8";
    private static final TobagoCallback APPLY_REQUEST_VALUES_CALLBACK = new ApplyRequestValuesCallback();
    private static final ContextCallback PROCESS_VALIDATION_CALLBACK = new ProcessValidationsCallback();
    private static final ContextCallback UPDATE_MODEL_VALUES_CALLBACK = new UpdateModelValuesCallback();
    private String formId;
    private String actionId;
    private Box actionPosition;

    public boolean getRendersChildren() {
        return true;
    }

    public String getFormId(FacesContext facesContext) {
        if (this.formId == null) {
            this.formId = this.getClientId(facesContext) + "::" + "form";
        }
        return this.formId;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (!AjaxUtils.isAjaxRequest(facesContext)) {
            super.encodeBegin(facesContext);
            ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeBegin(facesContext);
        }
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (AjaxUtils.isAjaxRequest(facesContext)) {
            new AjaxResponseRenderer().renderResponse(facesContext);
        } else {
            ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeChildren(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        if (!AjaxUtils.isAjaxRequest(facesContext)) {
            ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeEnd(facesContext);
            super.encodeEnd(facesContext);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(DebugUtils.toString(this.getParent(), 0));
        }
    }

    private void processDecodes0(FacesContext facesContext) {
        this.decode(facesContext);
        this.markSubmittedForm(facesContext);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(facesContext);
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.parseAndStoreComponents(context);
        if (ajaxComponents != null) {
            AbstractUIPage page = ComponentUtils.findPage(context);
            page.decode(context);
            page.markSubmittedForm(context);
            FacesContextUtils.setAjax(context, true);
            this.decodeActionComponent(context, page, ajaxComponents);
            for (Map.Entry<String, UIComponent> entry : ajaxComponents.entrySet()) {
                FacesContextUtils.setAjaxComponentId(context, entry.getKey());
                this.invokeOnComponent(context, entry.getKey(), APPLY_REQUEST_VALUES_CALLBACK);
            }
        } else {
            this.processDecodes0(context);
        }
    }

    private void decodeActionComponent(FacesContext facesContext, AbstractUIPage page, Map<String, UIComponent> ajaxComponents) {
        String id = page.getActionId();
        UIComponent actionComponent = null;
        if (id != null && (actionComponent = this.findComponent(id)) == null && FacesVersion.supports20() && FacesVersion.isMyfaces()) {
            String bugActionId = id.replaceAll(":\\d+:", ":");
            try {
                actionComponent = this.findComponent(bugActionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (actionComponent == null) {
            return;
        }
        for (UIComponent ajaxComponent : ajaxComponents.values()) {
            for (UIComponent component = actionComponent; component != null; component = component.getParent()) {
                if (component != ajaxComponent) continue;
                return;
            }
        }
        this.invokeOnComponent(facesContext, id, APPLY_REQUEST_VALUES_CALLBACK);
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(context);
        if (ajaxComponents != null) {
            for (Map.Entry<String, UIComponent> entry : ajaxComponents.entrySet()) {
                FacesContextUtils.setAjaxComponentId(context, entry.getKey());
                this.invokeOnComponent(context, entry.getKey(), PROCESS_VALIDATION_CALLBACK);
            }
        } else {
            super.processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(context);
        if (ajaxComponents != null) {
            for (Map.Entry<String, UIComponent> entry : ajaxComponents.entrySet()) {
                this.invokeOnComponent(context, entry.getKey(), UPDATE_MODEL_VALUES_CALLBACK);
            }
        } else {
            super.processUpdates(context);
        }
    }

    public void markSubmittedForm(FacesContext facesContext) {
        UIViewRoot viewRoot;
        UIComponent command;
        this.setSubmitted(false);
        String currentActionId = this.getActionId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("actionId = '" + currentActionId + "'");
        }
        if ((command = (viewRoot = facesContext.getViewRoot()).findComponent(currentActionId)) == null && currentActionId != null && currentActionId.matches(".*:\\d+:.*")) {
            currentActionId = currentActionId.replaceAll(":\\d+:", ":");
            try {
                command = viewRoot.findComponent(currentActionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(currentActionId);
            LOG.trace("command:{}", (Object)command);
            LOG.trace(DebugUtils.toString((UIComponent)viewRoot, 0));
        }
        if (command != null) {
            AbstractUIForm form = ComponentUtils.findForm(command);
            form.setSubmitted(true);
            if (LOG.isTraceEnabled()) {
                LOG.trace("form:{}", (Object)form);
                LOG.trace(form.getClientId(facesContext));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Illegal actionId! Render response...");
            }
            facesContext.renderResponse();
        }
    }

    @Deprecated
    public void updatePageState(FacesContext facesContext) {
    }

    @Deprecated
    public PageState getPageState(FacesContext facesContext) {
        ValueExpression expression = this.getValueExpression("state");
        if (expression != null) {
            ELContext elContext = facesContext.getELContext();
            PageState state = (PageState)expression.getValue(elContext);
            if (state == null) {
                state = new PageStateImpl();
                expression.setValue(elContext, (Object)state);
            }
            return state;
        }
        return null;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Box getActionPosition() {
        return this.actionPosition;
    }

    public void setActionPosition(Box actionPosition) {
        this.actionPosition = actionPosition;
    }

    @Deprecated
    public String getDefaultActionId() {
        Deprecation.LOG.error("The default action handling has been changed!");
        return null;
    }

    @Deprecated
    public void setDefaultActionId(String defaultActionId) {
        Deprecation.LOG.error("The default action handling has been changed!");
    }

    @Override
    public void onComponentPopulated(FacesContext facesContext, UIComponent parent) {
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(CreateComponentUtils.createAndInitLayout(facesContext, "org.apache.myfaces.tobago.GridLayout", "GridLayout", parent));
        }
    }

    @Override
    public List<LayoutComponent> getComponents() {
        return LayoutUtils.findLayoutChildren(this);
    }

    @Override
    public LayoutManager getLayoutManager() {
        UIComponent facet = this.getFacet("layout");
        if (facet == null) {
            return null;
        }
        if (facet instanceof LayoutManager) {
            return (LayoutManager)facet;
        }
        return (LayoutManager)((Object)ComponentUtils.findChild(facet, AbstractUILayoutBase.class));
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.getFacets().put("layout", (AbstractUILayoutBase)((Object)layoutManager));
    }

    @Override
    public boolean isLayoutChildren() {
        return this.isRendered();
    }

    @Override
    public abstract Measure getWidth();

    @Override
    public abstract Measure getHeight();
}

