/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.layout.BankHead;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.FactorList;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.Interval;
import org.apache.myfaces.tobago.internal.layout.IntervalList;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.AutoLayoutToken;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.LayoutToken;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;
import org.apache.myfaces.tobago.layout.PixelLayoutToken;
import org.apache.myfaces.tobago.layout.RelativeLayoutToken;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIGridLayout
extends AbstractUILayoutBase
implements LayoutManager,
SupportsMarkup {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIGridLayout.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";
    private Grid grid;

    public void init() {
        if (!this.getLayoutContainer().isLayoutChildren()) {
            return;
        }
        this.grid = new Grid(LayoutTokens.parse(this.getColumns()), LayoutTokens.parse(this.getRows()));
        List<LayoutComponent> components = this.getLayoutContainer().getComponents();
        for (LayoutComponent component : components) {
            component.setCurrentHeight(null);
            component.setCurrentWidth(null);
            this.grid.add(new OriginCell(component), component.getColumnSpan(), component.getRowSpan());
            if (LOG.isDebugEnabled()) {
                LOG.debug("\n" + this.grid);
            }
            if (!(component instanceof LayoutContainer) || !component.isRendered() && !this.isRigid()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().init();
        }
        this.grid.setColumnOverflow(this.isColumnOverflow());
        this.grid.setRowOverflow(this.isRowOverflow());
    }

    public void fixRelativeInsideAuto(Orientation orientation, boolean auto) {
        int i;
        if (!this.getLayoutContainer().isLayoutChildren()) {
            return;
        }
        BankHead[] heads = this.grid.getBankHeads(orientation);
        BankHead[] heads2 = this.grid.getBankHeads(orientation.other());
        if (auto) {
            for (i = 0; i < heads.length; ++i) {
                if (!(heads[i].getToken() instanceof RelativeLayoutToken)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Fixing layout token from * to auto, because a * in not allowed inside of a auto. Token * at index=" + i + ", orientation=" + (Object)((Object)orientation) + ", grid=\n" + this.grid);
                }
                heads[i].setToken(AutoLayoutToken.INSTANCE);
            }
        }
        for (i = 0; i < heads.length; ++i) {
            boolean neitherRendered = true;
            for (int j = 0; j < heads2.length; ++j) {
                Cell cell = this.grid.getCell(i, j, orientation);
                if (cell != null && cell.getComponent().isRendered()) {
                    neitherRendered = false;
                }
                if (!(cell instanceof OriginCell)) continue;
                OriginCell origin = (OriginCell)cell;
                LayoutComponent component = cell.getComponent();
                if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
                LayoutManager layoutManager = ((LayoutContainer)((Object)component)).getLayoutManager();
                boolean childAuto = origin.getSpan(orientation) == 1 && heads[i].getToken() instanceof AutoLayoutToken;
                layoutManager.fixRelativeInsideAuto(orientation, childAuto);
            }
            if (!neitherRendered || this.isRigid()) continue;
            heads[i].setRendered(false);
        }
    }

    public void preProcessing(Orientation orientation) {
        if (!this.getLayoutContainer().isLayoutChildren()) {
            return;
        }
        BankHead[] heads = this.grid.getBankHeads(orientation);
        BankHead[] heads2 = this.grid.getBankHeads(orientation.other());
        int i = 0;
        for (BankHead head : heads) {
            LayoutToken token = head.getToken();
            if (token instanceof PixelLayoutToken) {
                if (head.isRendered() || this.isRigid()) {
                    heads[i].setCurrent(((PixelLayoutToken)token).getMeasure());
                } else {
                    heads[i].setCurrent(Measure.ZERO);
                }
            }
            IntervalList intervalList = new IntervalList();
            for (int j = 0; j < heads2.length; ++j) {
                Cell cell = this.grid.getCell(i, j, orientation);
                if (!(cell instanceof OriginCell)) continue;
                OriginCell origin = (OriginCell)cell;
                LayoutComponent component = cell.getComponent();
                if (component instanceof LayoutContainer && (component.isRendered() || this.isRigid())) {
                    ((LayoutContainer)((Object)component)).getLayoutManager().preProcessing(orientation);
                }
                if (!(token instanceof AutoLayoutToken) && !(token instanceof RelativeLayoutToken) || !component.isRendered() && !this.isRigid()) continue;
                if (origin.getSpan(orientation) == 1) {
                    intervalList.add(new Interval(component, orientation));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Components with span > 1 will be ignored in 'auto' layout rows/columns.");
            }
            intervalList.evaluate();
            if (token instanceof AutoLayoutToken || token instanceof RelativeLayoutToken) {
                heads[i].setIntervalList(intervalList);
            }
            if (token instanceof AutoLayoutToken) {
                if (heads[i].isRendered()) {
                    if (intervalList.size() > 0) {
                        heads[i].setCurrent(intervalList.getCurrent());
                    } else {
                        heads[i].setCurrent(Measure.valueOf(100));
                        LOG.warn("Found an 'auto' token in {} definition, but there is no component inside with span = 1! So the value for 'auto' can't be evaluated (clientId={}). Using 100px.", (Object)(orientation == Orientation.HORIZONTAL ? "columns" : "rows"), (Object)this.getClientId(this.getFacesContext()));
                    }
                } else {
                    heads[i].setCurrent(Measure.ZERO);
                }
            }
            ++i;
        }
        Measure sum = Measure.ZERO;
        for (BankHead head : heads) {
            Measure size = null;
            LayoutToken token = head.getToken();
            if (!(token instanceof RelativeLayoutToken)) {
                size = head.getCurrent();
            }
            if (size == null) {
                sum = null;
                break;
            }
            sum = sum.add(size);
        }
        if (sum != null) {
            sum = sum.add(LayoutUtils.getBorderBegin(orientation, this.getLayoutContainer()));
            sum = sum.add(LayoutUtils.getPaddingBegin(orientation, this.getLayoutContainer()));
            sum = sum.add(this.getMarginBegin(orientation));
            sum = sum.add(this.computeSpacing(orientation, 0, heads.length));
            sum = sum.add(this.getMarginEnd(orientation));
            sum = sum.add(LayoutUtils.getPaddingEnd(orientation, this.getLayoutContainer()));
            sum = sum.add(LayoutUtils.getBorderEnd(orientation, this.getLayoutContainer()));
            LayoutUtils.setCurrentSize(orientation, this.getLayoutContainer(), sum);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void mainProcessing(Orientation orientation) {
        if (!this.getLayoutContainer().isLayoutChildren()) {
            return;
        }
        BankHead[] heads = this.grid.getBankHeads(orientation);
        BankHead[] heads2 = this.grid.getBankHeads(orientation.other());
        FactorList factorList = new FactorList();
        for (BankHead head : heads) {
            if (!(head.getToken() instanceof RelativeLayoutToken) || !head.isRendered()) continue;
            factorList.add(((RelativeLayoutToken)head.getToken()).getFactor());
        }
        if (!factorList.isEmpty()) {
            LayoutContainer container = this.getLayoutContainer();
            Measure available = LayoutUtils.getCurrentSize(orientation, container);
            if (available != null) {
                for (BankHead bankHead : heads) {
                    available = available.subtractNotNegative(bankHead.getCurrent());
                }
                available = available.subtractNotNegative(LayoutUtils.getBorderBegin(orientation, container));
                available = available.subtractNotNegative(LayoutUtils.getPaddingBegin(orientation, container));
                available = available.subtractNotNegative(this.getMarginBegin(orientation));
                available = available.subtractNotNegative(this.computeSpacing(orientation, 0, heads.length));
                available = available.subtractNotNegative(this.getMarginEnd(orientation));
                available = available.subtractNotNegative(LayoutUtils.getPaddingEnd(orientation, container));
                available = available.subtractNotNegative(LayoutUtils.getBorderEnd(orientation, container));
                if (this.grid.isOverflow(orientation.other())) {
                    ClientProperties client = ClientProperties.getInstance(FacesContext.getCurrentInstance());
                    Measure scrollbar = orientation == Orientation.HORIZONTAL ? client.getVerticalScrollbarWeight() : client.getHorizontalScrollbarWeight();
                    available = available.subtractNotNegative(scrollbar);
                }
                List<Measure> partition = factorList.partition(available);
                int i = 0;
                int j = 0;
                for (BankHead head : heads) {
                    if (head.getToken() instanceof RelativeLayoutToken && head.isRendered()) {
                        heads[i].setCurrent(Measure.max(partition.get(j), heads[i].getIntervalList().getMinimum()));
                        ++j;
                    }
                    ++i;
                }
            } else {
                LOG.warn("No width/height set but needed for *!");
            }
        }
        for (int i = 0; i < heads.length; ++i) {
            for (int j = 0; j < heads2.length; ++j) {
                void var10_27;
                Cell cell = this.grid.getCell(i, j, orientation);
                if (!(cell instanceof OriginCell)) continue;
                LayoutComponent component = cell.getComponent();
                Integer span = ((OriginCell)cell).getSpan(orientation);
                Measure measure = Measure.ZERO;
                for (int k = 0; k < span; ++k) {
                    Measure measure2 = var10_27.add(heads[i + k].getCurrent());
                }
                Measure measure3 = var10_27.add(this.computeSpacing(orientation, i, span));
                Measure current = LayoutUtils.getCurrentSize(orientation, component);
                if (current == null) {
                    LayoutUtils.setCurrentSize(orientation, component, measure3);
                }
                if (!(component instanceof LayoutContainer) || !component.isRendered() && !this.isRigid()) continue;
                ((LayoutContainer)((Object)component)).getLayoutManager().mainProcessing(orientation);
            }
        }
        Measure size = Measure.ZERO;
        size = size.add(LayoutUtils.getPaddingBegin(orientation, this.getLayoutContainer()));
        size = size.add(this.getMarginBegin(orientation));
        size = size.add(this.computeSpacing(orientation, 0, heads.length));
        for (BankHead head : heads) {
            size = size.add(head.getCurrent());
        }
        size = size.add(this.getMarginEnd(orientation));
        if ((size = size.add(LayoutUtils.getPaddingEnd(orientation, this.getLayoutContainer()))).greaterThan(LayoutUtils.getCurrentSize(orientation, this.getLayoutContainer()))) {
            this.grid.setOverflow(true, orientation);
        }
    }

    public void postProcessing(Orientation orientation) {
        if (!this.getLayoutContainer().isLayoutChildren()) {
            return;
        }
        BankHead[] heads = this.grid.getBankHeads(orientation);
        BankHead[] heads2 = this.grid.getBankHeads(orientation.other());
        for (int i = 0; i < heads.length; ++i) {
            for (int j = 0; j < heads2.length; ++j) {
                Cell cell = this.grid.getCell(i, j, orientation);
                if (!(cell instanceof OriginCell)) continue;
                LayoutComponent component = cell.getComponent();
                Measure position = Measure.ZERO;
                position = position.add(LayoutUtils.getPaddingBegin(orientation, this.getLayoutContainer()));
                position = position.add(this.getMarginBegin(orientation));
                for (int k = 0; k < i; ++k) {
                    if (heads[k] == null || heads[k].getCurrent() == null || !heads[k].isRendered() || !heads[k].getCurrent().greaterThan(Measure.ZERO)) continue;
                    position = position.add(heads[k].getCurrent());
                    position = position.add(this.getSpacing(orientation));
                }
                if (orientation == Orientation.HORIZONTAL) {
                    component.setLeft(position);
                } else {
                    component.setTop(position);
                }
                if (component instanceof LayoutContainer && (component.isRendered() || this.isRigid())) {
                    ((LayoutContainer)((Object)component)).getLayoutManager().postProcessing(orientation);
                }
                boolean scroll = this.grid.isOverflow(orientation);
                if (orientation == Orientation.HORIZONTAL) {
                    this.getLayoutContainer().setOverflowX(scroll);
                    continue;
                }
                this.getLayoutContainer().setOverflowY(scroll);
            }
        }
    }

    private LayoutContainer getLayoutContainer() {
        return ComponentUtils.findAncestor(this.getParent(), LayoutContainer.class);
    }

    public Measure getSpacing(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.getColumnSpacing() : this.getRowSpacing();
    }

    public Measure getMarginBegin(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.getMarginLeft() : this.getMarginTop();
    }

    public Measure getMarginEnd(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.getMarginRight() : this.getMarginBottom();
    }

    private Measure computeSpacing(Orientation orientation, int startIndex, int length) {
        BankHead[] heads = this.grid.getBankHeads(orientation);
        int count = 0;
        for (int i = startIndex; i < startIndex + length; ++i) {
            if (!heads[i].isRendered() || heads[i].getCurrent() != null && !heads[i].getCurrent().greaterThan(Measure.ZERO)) continue;
            ++count;
        }
        if (count > 0) {
            return this.getSpacing(orientation).multiply(count - 1);
        }
        return Measure.ZERO;
    }

    public abstract String getRows();

    public abstract void setRows(String var1);

    public abstract String getColumns();

    public abstract void setColumns(String var1);

    @Deprecated
    public abstract Measure getCellspacing();

    public abstract Measure getRowSpacing();

    public abstract Measure getColumnSpacing();

    public abstract Measure getMarginLeft();

    public abstract Measure getMarginTop();

    public abstract Measure getMarginRight();

    public abstract Measure getMarginBottom();

    public abstract boolean isColumnOverflow();

    public abstract boolean isRowOverflow();

    public abstract boolean isRigid();

    public boolean getRendersChildren() {
        return false;
    }

    public String toString(int depth) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("#");
        builder.append(this.getClientId(FacesContext.getCurrentInstance()));
        builder.append("\n");
        if (this.grid != null) {
            int i;
            builder.append(StringUtils.repeat("  ", depth + 4));
            builder.append("horiz.: ");
            BankHead[] heads = this.grid.getBankHeads(Orientation.HORIZONTAL);
            for (i = 0; i < heads.length; ++i) {
                if (i != 0) {
                    builder.append(StringUtils.repeat("  ", depth + 4 + 4));
                }
                builder.append(heads[i]);
                builder.append("\n");
            }
            builder.append(StringUtils.repeat("  ", depth + 4));
            builder.append("verti.: ");
            heads = this.grid.getBankHeads(Orientation.VERTICAL);
            for (i = 0; i < heads.length; ++i) {
                if (i != 0) {
                    builder.append(StringUtils.repeat("  ", depth + 4 + 4));
                }
                builder.append(heads[i]);
                builder.append("\n");
            }
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

