/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThemeResources
implements Serializable {
    private final boolean production;
    private final List<ThemeScript> scriptList = new ArrayList<ThemeScript>();
    private final List<ThemeScript> scriptExcludes = new ArrayList<ThemeScript>();
    private final List<ThemeStyle> styleList = new ArrayList<ThemeStyle>();
    private final List<ThemeStyle> styleExcludes = new ArrayList<ThemeStyle>();

    public ThemeResources(boolean production) {
        this.production = production;
    }

    public void merge(ThemeResources toAddResources) {
        int i;
        if (this == toAddResources) {
            return;
        }
        for (i = toAddResources.scriptList.size() - 1; i >= 0; --i) {
            ThemeScript script = toAddResources.scriptList.get(i);
            this.scriptList.remove(script);
            if (this.scriptExcludes.contains(script)) continue;
            this.scriptList.add(0, script);
        }
        for (i = toAddResources.styleList.size() - 1; i >= 0; --i) {
            ThemeStyle style = toAddResources.styleList.get(i);
            this.styleList.remove(style);
            if (this.styleExcludes.contains(style)) continue;
            this.styleList.add(0, style);
        }
    }

    public boolean isProduction() {
        return this.production;
    }

    public boolean addScript(ThemeScript script, boolean exclude) {
        return exclude ? this.scriptExcludes.add(script) : this.scriptList.add(script);
    }

    public boolean addStyle(ThemeStyle style, boolean exclude) {
        return exclude ? this.styleExcludes.add(style) : this.styleList.add(style);
    }

    public List<ThemeScript> getScriptList() {
        return this.scriptList;
    }

    public List<ThemeStyle> getStyleList() {
        return this.styleList;
    }
}

