/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.ObjectArrayIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Markup
implements Serializable,
Iterable<String> {
    public static final Markup NULL = new Markup((String)null);
    public static final Markup ASCENDING = Markup.valueOf("ascending");
    public static final Markup CENTER = Markup.valueOf("center");
    public static final Markup CLICKABLE = Markup.valueOf("clickable");
    public static final Markup DEFAULT = Markup.valueOf("default");
    public static final Markup DELETED = Markup.valueOf("deleted");
    public static final Markup DESCENDING = Markup.valueOf("descending");
    public static final Markup DISABLED = Markup.valueOf("disabled");
    public static final Markup ERROR = Markup.valueOf("error");
    public static final Markup EVEN = Markup.valueOf("even");
    public static final Markup EXPANDED = Markup.valueOf("expanded");
    public static final Markup FILLER = Markup.valueOf("filler");
    public static final Markup FATAL = Markup.valueOf("fatal");
    public static final Markup FIRST = Markup.valueOf("first");
    public static final Markup FOLDER = Markup.valueOf("folder");
    public static final Markup INFO = Markup.valueOf("info");
    public static final Markup INLINE = Markup.valueOf("inline");
    public static final Markup LEFT = Markup.valueOf("left");
    public static final Markup MARKED = Markup.valueOf("marked");
    public static final Markup MODAL = Markup.valueOf("modal");
    public static final Markup NUMBER = Markup.valueOf("number");
    public static final Markup ODD = Markup.valueOf("odd");
    public static final Markup PORTLET = Markup.valueOf("portlet");
    public static final Markup PURE = Markup.valueOf("pure");
    public static final Markup READONLY = Markup.valueOf("readonly");
    public static final Markup REQUIRED = Markup.valueOf("required");
    public static final Markup RESIZABLE = Markup.valueOf("resizable");
    public static final Markup RIGHT = Markup.valueOf("right");
    public static final Markup SECONDS = Markup.valueOf("seconds");
    public static final Markup SELECTED = Markup.valueOf("selected");
    public static final Markup SHEET_SELECT_ALL = Markup.valueOf("sheetSelectAll");
    public static final Markup SHEET_DESELECT_ALL = Markup.valueOf("sheetDeselectAll");
    public static final Markup SHEET_TOGGLE_ALL = Markup.valueOf("sheetToggleAll");
    public static final Markup SORTABLE = Markup.valueOf("sortable");
    public static final Markup STRONG = Markup.valueOf("strong");
    public static final Markup TOP = Markup.valueOf("top");
    public static final Markup WARN = Markup.valueOf("warn");
    private final String[] values;
    private final String value;

    private Markup(String[] values) {
        this.values = values;
        this.value = null;
    }

    private Markup(String value) {
        this.values = null;
        this.value = value;
    }

    public static Markup valueOf(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return Markup.valueOf(values[0]);
        }
        Markup markup = new Markup((String[])values.clone());
        for (int i = 0; i < markup.values.length; ++i) {
            markup.values[i] = markup.values[i].trim();
        }
        return markup;
    }

    public static Markup valueOf(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        if (value.contains(",")) {
            String[] strings = StringUtils.split(value, ", \t\n");
            return new Markup(strings);
        }
        return new Markup(value.trim());
    }

    public static Markup valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Markup) {
            return (Markup)value;
        }
        if (value instanceof String) {
            return Markup.valueOf((String)value);
        }
        if (value instanceof String[]) {
            return Markup.valueOf((String[])value);
        }
        if (value instanceof Iterable) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object object : (Iterable)value) {
                list.add(object.toString());
            }
            return Markup.valueOf(list.toArray(new String[list.size()]));
        }
        return Markup.valueOf(value.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Markup markup = (Markup)o;
        if (this.value != null ? !this.value.equals(markup.value) : markup.value != null) {
            return false;
        }
        return Arrays.equals(this.values, markup.values);
    }

    public int hashCode() {
        int result = this.values != null ? Arrays.hashCode(this.values) : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        if (this.value != null) {
            return new SingletonIterator((Object)this.value);
        }
        if (this.values != null) {
            return new ObjectArrayIterator((Object[])this.values);
        }
        return EmptyIterator.INSTANCE;
    }

    public Markup add(Markup markup) {
        if (markup == null) {
            return this;
        }
        if (markup == NULL) {
            return this;
        }
        if (markup.value != null) {
            return this.add(markup.value);
        }
        Markup result = this;
        if (markup.values != null) {
            for (String summand : markup.values) {
                result = result.add(summand);
            }
        }
        return result;
    }

    private Markup add(String summand) {
        if (summand == null) {
            return this;
        }
        if (this.values == null) {
            if (this.value == null) {
                return Markup.valueOf(summand);
            }
            if (summand.equals(this.value)) {
                return this;
            }
            return Markup.valueOf(new String[]{this.value, summand});
        }
        if (ArrayUtils.contains(this.values, summand)) {
            return this;
        }
        String[] strings = new String[this.values.length + 1];
        System.arraycopy(this.values, 0, strings, 0, this.values.length);
        strings[this.values.length] = summand;
        return Markup.valueOf(strings);
    }

    public Markup remove(Markup markup) {
        if (markup.value != null) {
            return this.remove(markup.value);
        }
        Markup result = this;
        for (String summand : markup.values) {
            result = result.remove(summand);
        }
        return result;
    }

    private Markup remove(String summand) {
        if (summand == null) {
            return this;
        }
        if (this.values == null) {
            if (this.value == null) {
                return this;
            }
            if (summand.equals(this.value)) {
                return NULL;
            }
            return this;
        }
        if (ArrayUtils.contains(this.values, summand)) {
            String[] strings = new String[this.values.length - 1];
            int found = 0;
            for (int i = 0; i < strings.length; ++i) {
                if (this.values[i].equals(summand)) {
                    ++found;
                }
                strings[i] = this.values[i + found];
            }
            return Markup.valueOf(strings);
        }
        return this;
    }

    public boolean contains(String markup) {
        if (markup == null) {
            return false;
        }
        if (this == NULL) {
            return this == Markup.valueOf(markup);
        }
        if (this.value != null) {
            return this.value.equals(markup);
        }
        for (String v : this.values) {
            if (!v.equals(markup)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        if (this.values == null) {
            return "null";
        }
        return Arrays.toString(this.values);
    }
}

