/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeIndent;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIndentRenderer
extends LayoutComponentRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeIndent indent = (UITreeIndent)component;
        AbstractUITreeNode node = (AbstractUITreeNode)ComponentUtils.findAncestor((UIComponent)indent, AbstractUITreeNode.class);
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)indent, AbstractUIData.class);
        boolean folder = node.isFolder();
        int level = node.getLevel();
        List junctions = node.getJunctions();
        boolean showRoot = data.isShowRoot();
        boolean showJunctions = indent.isShowJunctions();
        boolean showRootJunction = data.isShowRootJunction();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        boolean showLines = showJunctions && data instanceof UITree;
        boolean showIcons = showJunctions;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("span", (UIComponent)indent);
        writer.writeIdAttribute(indent.getClientId(facesContext));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)indent);
        this.encodeIndent(facesContext, writer, node, showLines, showIcons, showRootJunction, showRoot, junctions);
        this.encodeTreeJunction(facesContext, writer, node, showLines, showIcons, showRootJunction, junctions, expanded, folder, level == 0);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.endElement("span");
    }

    private void encodeIndent(FacesContext facesContext, TobagoResponseWriter writer, AbstractUITreeNode node, boolean showLines, boolean showIcons, boolean showRootJunction, boolean showRoot, List<Boolean> junctions) throws IOException {
        int i;
        boolean dropFirst = !showRoot || !showRootJunction && (showLines || showIcons);
        String blank = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/blank");
        String perpendicular = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/I");
        int n = i = dropFirst ? 1 : 0;
        while (i < junctions.size() - 1) {
            Boolean junction = junctions.get(i);
            writer.startElement("img", null);
            writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"junction"));
            writer.writeAttribute("alt", "", false);
            if (junction.booleanValue() && showLines) {
                writer.writeAttribute("src", perpendicular, true);
            } else {
                writer.writeAttribute("src", blank, true);
            }
            writer.endElement("img");
            ++i;
        }
    }

    private void encodeTreeJunction(FacesContext facesContext, TobagoResponseWriter writer, AbstractUITreeNode node, boolean showLines, boolean showIcons, boolean showRootJunction, List<Boolean> junctions, boolean expanded, boolean folder, boolean root) throws IOException {
        String close;
        String open;
        if (!showIcons || !showRootJunction && root) {
            return;
        }
        boolean hasNextSibling = junctions.get(junctions.size() - 1);
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"toggle", (Markup)Markup.NULL));
        if (showLines) {
            if (root) {
                open = "Rminus";
                close = "Rplus";
            } else if (hasNextSibling) {
                if (folder) {
                    open = "Tminus";
                    close = "Tplus";
                } else {
                    open = "T";
                    close = "T";
                }
            } else if (folder) {
                open = "Lminus";
                close = "Lplus";
            } else {
                open = "L";
                close = "L";
            }
        } else if (folder) {
            open = "minus";
            close = "plus";
        } else {
            open = "blank";
            close = "blank";
        }
        String srcOpen = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)("image/" + open));
        String srcClose = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)("image/" + close));
        String src = expanded ? srcOpen : srcClose;
        writer.writeAttribute("src", src, true);
        if (folder) {
            writer.writeAttribute("data-tobago-src-open", srcOpen, true);
            writer.writeAttribute("data-tobago-src-close", srcClose, true);
        }
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }
}

