/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIButton;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIFileDrop;
import org.apache.myfaces.tobago.component.UILink;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIFile;
import org.apache.myfaces.tobago.internal.component.AbstractUIFileDrop;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanel;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.FileRenderer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class FileDropRenderer
extends FileRenderer {
    private static final String FILE_DROP_DATA_ATTRIBUTE_NAME = "tobago-file-drop";

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        UIFileDrop fileDrop = (UIFileDrop)component;
        if (fileDrop.getFacet("change") == null) {
            this.createActionFacet(facesContext, fileDrop);
        }
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType(fileDrop);
        switch (visibleType) {
            case DROP_ZONE: {
                UIOut view = (UIOut)fileDrop.getFacet(visibleType.name());
                if (view == null) {
                    view = (UIOut)this.createViewComponent(facesContext, fileDrop, "org.apache.myfaces.tobago.Out", "Out");
                    fileDrop.getFacets().put(visibleType.name(), view);
                }
                this.prepareRender(facesContext, (UIComponent)view, fileDrop);
                break;
            }
            case BUTTON: {
                UIButton button = (UIButton)fileDrop.getFacet(visibleType.name());
                if (button == null) {
                    button = (UIButton)this.createViewComponent(facesContext, fileDrop, "org.apache.myfaces.tobago.Button", "Button");
                    fileDrop.getFacets().put(visibleType.name(), button);
                }
                this.prepareRender(facesContext, (UIComponent)button, fileDrop);
                break;
            }
            case LINK: {
                UILink image = (UILink)fileDrop.getFacet(visibleType.name());
                if (image == null) {
                    image = (UILink)this.createViewComponent(facesContext, fileDrop, "org.apache.myfaces.tobago.Link", "Link");
                    fileDrop.getFacets().put(visibleType.name(), image);
                }
                this.prepareRender(facesContext, (UIComponent)image, fileDrop);
                break;
            }
        }
    }

    private void prepareRender(FacesContext facesContext, UIComponent command, UIFileDrop fileDrop) throws IOException {
        super.prepareRender(facesContext, command);
    }

    protected void writeDataAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIFile file) throws IOException {
        String dataValue = this.buildDataValue(facesContext, (UIFileDrop)file);
        ComponentUtils.putDataAttribute((UIComponent)file, (Object)FILE_DROP_DATA_ATTRIBUTE_NAME, (Object)dataValue);
        super.writeDataAttributes(facesContext, writer, file);
    }

    private String buildDataValue(FacesContext facesContext, UIFileDrop fileDrop) {
        return "{\"dropZoneId\":\"" + this.calculateDropZoneId(facesContext, fileDrop) + "\"}";
    }

    private String calculateDropZoneId(FacesContext facesContext, UIFileDrop fileDrop) {
        String dropZoneId = fileDrop.getDropZoneId();
        if ("@this".equals(dropZoneId)) {
            dropZoneId = ":" + fileDrop.getClientId(facesContext);
        } else if ("@parent".equals(dropZoneId)) {
            dropZoneId = ":" + fileDrop.getParent().getClientId(facesContext);
        } else if ("@panel".equals(dropZoneId)) {
            dropZoneId = ":" + this.findPanel((UIComponent)fileDrop).getClientId(facesContext);
        }
        return dropZoneId;
    }

    private AbstractUIPanel findPanel(UIComponent component) {
        if (component instanceof AbstractUIPanel) {
            return (AbstractUIPanel)component;
        }
        if (component != null) {
            return this.findPanel(component.getParent());
        }
        throw new IllegalStateException("No parent tc:panel found!");
    }

    private void createActionFacet(FacesContext facesContext, UIFileDrop fileDrop) {
        ActionListener[] actionListeners;
        UICommand command = (UICommand)facesContext.getApplication().createComponent(facesContext, "org.apache.myfaces.tobago.Command", "Command");
        command.setId(fileDrop.getId() + "-command-facet");
        ValueExpression valueExpression = fileDrop.getValueExpression("renderedPartially");
        if (valueExpression != null) {
            command.setValueExpression("renderedPartially", valueExpression);
        } else {
            String[] renderedPartially = fileDrop.getRenderedPartially();
            if (renderedPartially != null && renderedPartially.length != 0) {
                command.setRenderedPartially(renderedPartially);
            } else {
                valueExpression = fileDrop.getValueExpression("dropZoneId");
                if (valueExpression != null) {
                    command.setValueExpression("renderedPartially", valueExpression);
                } else {
                    command.setRenderedPartially(new String[]{this.calculateDropZoneId(facesContext, fileDrop)});
                }
            }
        }
        MethodExpression actionExpression = fileDrop.getActionExpression();
        if (actionExpression != null) {
            command.setActionExpression(actionExpression);
        }
        if ((actionListeners = fileDrop.getActionListeners()) != null) {
            for (ActionListener listener : actionListeners) {
                command.addActionListener(listener);
            }
        }
        fileDrop.getFacets().put("change", command);
    }

    protected UIComponent createViewComponent(FacesContext facesContext, UIFileDrop fileDrop, String componentType, String rendererType) {
        UIComponent viewComponent = facesContext.getApplication().createComponent(facesContext, componentType, rendererType);
        viewComponent.setId(fileDrop.getId() + "-view-facet");
        this.setOmit(viewComponent);
        String label = fileDrop.getLabel();
        String image = fileDrop.getImage();
        ValueExpression valueExpression = fileDrop.getValueExpression("label");
        if (valueExpression != null) {
            this.setLabelExpression(viewComponent, valueExpression);
        } else if (label != null) {
            this.setLabel(viewComponent, label);
        } else if (image == null) {
            this.setLabel(viewComponent, this.getDefaultLabel(facesContext));
        }
        valueExpression = fileDrop.getValueExpression("image");
        if (valueExpression != null) {
            viewComponent.setValueExpression("image", valueExpression);
        } else {
            this.setImage(viewComponent, image);
        }
        return viewComponent;
    }

    private void setImage(UIComponent command, String image) {
        if (command instanceof UIButton) {
            ((UIButton)command).setImage(image);
        } else if (command instanceof UILink) {
            ((UILink)command).setImage(image);
        }
    }

    private void setOmit(UIComponent command) {
        if (command instanceof UIButton) {
            ((UIButton)command).setOmit(true);
        } else if (command instanceof UILink) {
            ((UILink)command).setOmit(true);
        }
    }

    private void setLabelExpression(UIComponent viewComponent, ValueExpression valueExpression) {
        if (viewComponent instanceof UIOut) {
            viewComponent.setValueExpression("value", valueExpression);
        } else {
            viewComponent.setValueExpression("label", valueExpression);
        }
    }

    private void setLabel(UIComponent command, String label) {
        if (command instanceof UIButton) {
            ((UIButton)command).setLabel(label);
        } else if (command instanceof UILink) {
            ((UILink)command).setLabel(label);
        } else if (command instanceof UIOut) {
            ((UIOut)command).setValue((Object)label);
        }
    }

    private String getDefaultLabel(FacesContext facesContext) {
        return ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.fileDrop.defaultLabel");
    }

    protected void writeVisibleInput(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIFile file, String clientId, Style style) throws IOException {
        UIFileDrop fileDrop = (UIFileDrop)file;
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType(fileDrop);
        switch (visibleType) {
            case DROP_ZONE: {
                this.writeDropZone(facesContext, writer, fileDrop);
                break;
            }
            case FILE: {
                super.writeVisibleInput(facesContext, writer, file, clientId, style);
                break;
            }
            case BUTTON: {
                this.writeButton(facesContext, writer, fileDrop);
                break;
            }
            case LINK: {
                this.writeImage(facesContext, writer, fileDrop);
                break;
            }
        }
    }

    private void writeDropZone(FacesContext facesContext, TobagoResponseWriter writer, UIFileDrop fileDrop) throws IOException {
        this.writeComponent(facesContext, fileDrop.getFacet(AbstractUIFileDrop.VisibleType.DROP_ZONE.name()), fileDrop);
    }

    private void writeButton(FacesContext facesContext, TobagoResponseWriter writer, UIFileDrop fileDrop) throws IOException {
        this.writeComponent(facesContext, fileDrop.getFacet(AbstractUIFileDrop.VisibleType.BUTTON.name()), fileDrop);
    }

    private void writeImage(FacesContext facesContext, TobagoResponseWriter writer, UIFileDrop fileDrop) throws IOException {
        this.writeComponent(facesContext, fileDrop.getFacet(AbstractUIFileDrop.VisibleType.LINK.name()), fileDrop);
    }

    private void writeComponent(FacesContext facesContext, UIComponent component, UIFileDrop fileDrop) throws IOException {
        if (AbstractUIFileDrop.VisibleType.DROP_ZONE != this.getVisibleType(fileDrop) && component instanceof LayoutBase) {
            ((LayoutBase)component).setCurrentWidth(fileDrop.getCurrentWidth());
            ((LayoutBase)component).setCurrentHeight(fileDrop.getCurrentHeight());
            ((LayoutBase)component).setLeft(Measure.valueOf((int)0));
            ((LayoutBase)component).setTop(Measure.valueOf((int)0));
        }
        component.encodeBegin(facesContext);
        component.encodeChildren(facesContext);
        component.encodeEnd(facesContext);
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType((UIFileDrop)component);
        switch (visibleType) {
            case FILE: {
                return this.getResourceManager().getThemeMeasure(facesContext, "File", null, "minimumHeight");
            }
            case BUTTON: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Button", null, "minimumHeight");
            }
            case LINK: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Link", null, "minimumHeight");
            }
        }
        return null;
    }

    public Measure getMinimumHeight(FacesContext facesContext, Configurable component) {
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType((UIFileDrop)component);
        switch (visibleType) {
            case DROP_ZONE: {
                super.getMinimumHeight(facesContext, component);
            }
            case FILE: {
                return this.getResourceManager().getThemeMeasure(facesContext, "File", null, "minimumHeight");
            }
            case BUTTON: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Button", null, "minimumHeight");
            }
            case LINK: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Link", null, "minimumHeight");
            }
        }
        return Measure.ZERO;
    }

    public Measure getPreferredHeight(FacesContext facesContext, Configurable component) {
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType((UIFileDrop)component);
        switch (visibleType) {
            case DROP_ZONE: {
                super.getPreferredHeight(facesContext, component);
            }
            case FILE: {
                return this.getResourceManager().getThemeMeasure(facesContext, "File", null, "preferredHeight");
            }
            case BUTTON: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Button", null, "preferredHeight");
            }
            case LINK: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Link", null, "preferredHeight");
            }
        }
        return Measure.ZERO;
    }

    public Measure getMaximumHeight(FacesContext facesContext, Configurable component) {
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType((UIFileDrop)component);
        switch (visibleType) {
            case FILE: {
                return this.getResourceManager().getThemeMeasure(facesContext, "File", null, "maximumHeight");
            }
            case BUTTON: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Button", null, "maximumHeight");
            }
            case LINK: {
                return this.getResourceManager().getThemeMeasure(facesContext, "Link", null, "maximumHeight");
            }
        }
        return null;
    }

    public Measure getPreferredWidth(FacesContext facesContext, Configurable component) {
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType((UIFileDrop)component);
        switch (visibleType) {
            case BUTTON: {
                UIButton button = (UIButton)((UIComponent)component).getFacet(visibleType.name());
                return button.getPreferredWidth();
            }
        }
        return super.getPreferredWidth(facesContext, component);
    }

    protected Measure getPrettyWidthSub(FacesContext facesContext, AbstractUIFile file) {
        return this.getResourceManager().getThemeMeasure(facesContext, "File", null, "prettyWidthSub");
    }

    protected Classes getCssClasses(UIComponent component, String sub) {
        return super.getCssClasses(this.getCssComponent(component, sub), sub);
    }

    private UIComponent getCssComponent(UIComponent component, String sub) {
        AbstractUIFileDrop.VisibleType visibleType = this.getVisibleType((UIFileDrop)component);
        if ("real".equals(sub) || visibleType.equals((Object)AbstractUIFileDrop.VisibleType.FILE)) {
            return this.createCssComponent("File", component);
        }
        switch (visibleType) {
            case DROP_ZONE: {
                return component;
            }
        }
        return this.createCssComponent("Panel", component);
    }

    private UIComponent createCssComponent(String rendererType, UIComponent component) {
        UIOutput cssComponent;
        if (component instanceof SupportsMarkup) {
            SupportsMarkup supportsMarkup = (SupportsMarkup)component;
            UIOut uiOut = new UIOut();
            uiOut.setMarkup(supportsMarkup.getMarkup());
            cssComponent = uiOut;
        } else {
            cssComponent = new UIOutput();
        }
        cssComponent.setRendererType(rendererType);
        return cssComponent;
    }

    private AbstractUIFileDrop.VisibleType getVisibleType(UIFileDrop fileDrop) {
        return AbstractUIFileDrop.VisibleType.asEnum((String)fileDrop.getVisibleType());
    }
}

