/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.util.Map;
import org.apache.myfaces.tobago.internal.context.DateTimeI18n;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.Popup;

public class JsonUtils {
    private JsonUtils() {
    }

    private static void encode(StringBuilder builder, String name, String[] value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        JsonUtils.encode(builder, value);
        builder.append(",");
    }

    public static void encode(StringBuilder builder, String[] value) {
        builder.append("[");
        boolean colon = false;
        for (String item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(item);
            builder.append("\"");
            colon = true;
        }
        builder.append("]");
    }

    static void encode(StringBuilder builder, String name, Boolean value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(Boolean.toString(value));
        builder.append(",");
    }

    static void encode(StringBuilder builder, String name, Integer value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(Integer.toString(value));
        builder.append(",");
    }

    static void encode(StringBuilder builder, String name, String value) {
        String escaped = value.replaceAll("\\\"", "\\\\\\\"");
        builder.append("\"");
        builder.append(name);
        builder.append("\":\"");
        builder.append(escaped);
        builder.append("\",");
    }

    public static String encode(CommandMap commandMap) {
        Map<String, Command> other;
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        Command click = commandMap.getClick();
        if (click != null) {
            JsonUtils.encode(builder, "click", click);
        }
        if ((other = commandMap.getOther()) != null) {
            for (Map.Entry<String, Command> entry : other.entrySet()) {
                JsonUtils.encode(builder, entry.getKey(), entry.getValue());
            }
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    static void encode(StringBuilder builder, String name, Command command) {
        Boolean omit;
        String script;
        Popup popup;
        Integer delay;
        String confirmation;
        String focus;
        String[] partially;
        String url;
        String target;
        Boolean transition;
        builder.append("\"");
        builder.append(name);
        builder.append("\":{");
        int initialLength = builder.length();
        String action = command.getAction();
        if (action != null) {
            JsonUtils.encode(builder, "action", action);
        }
        if ((transition = command.getTransition()) != null && !transition.booleanValue()) {
            JsonUtils.encode(builder, "transition", transition);
        }
        if ((target = command.getTarget()) != null) {
            JsonUtils.encode(builder, "target", target);
        }
        if ((url = command.getUrl()) != null) {
            JsonUtils.encode(builder, "url", url);
        }
        if ((partially = command.getPartially()) != null && partially.length > 0) {
            if (partially.length == 1) {
                JsonUtils.encode(builder, "partially", partially[0]);
            } else {
                JsonUtils.encode(builder, "partially", partially);
            }
        }
        if ((focus = command.getFocus()) != null) {
            JsonUtils.encode(builder, "focus", focus);
        }
        if ((confirmation = command.getConfirmation()) != null) {
            JsonUtils.encode(builder, "confirmation", confirmation);
        }
        if ((delay = command.getDelay()) != null) {
            JsonUtils.encode(builder, "delay", delay);
        }
        if ((popup = command.getPopup()) != null) {
            JsonUtils.encode(builder, "popup", popup);
        }
        if ((script = command.getScript()) != null) {
            JsonUtils.encode(builder, "script", script);
        }
        if ((omit = command.getOmit()) != null && omit.booleanValue()) {
            JsonUtils.encode(builder, "omit", omit);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    static void encode(StringBuilder builder, String name, Popup popup) {
        Boolean immediate;
        builder.append("\"");
        builder.append(name);
        builder.append("\":{");
        int initialLength = builder.length();
        String command = popup.getCommand();
        if (command != null) {
            JsonUtils.encode(builder, "command", command);
        }
        if ((immediate = popup.isImmediate()) != null) {
            JsonUtils.encode(builder, "immediate", immediate);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    public static String encode(DateTimeI18n dateTimeI18n) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        JsonUtils.encode(builder, "monthNames", dateTimeI18n.getMonthNames());
        JsonUtils.encode(builder, "monthNamesShort", dateTimeI18n.getMonthNamesShort());
        JsonUtils.encode(builder, "dayNames", dateTimeI18n.getDayNames());
        JsonUtils.encode(builder, "dayNamesShort", dateTimeI18n.getDayNamesShort());
        JsonUtils.encode(builder, "dayNamesMin", dateTimeI18n.getDayNamesMin());
        JsonUtils.encode(builder, "firstDay", dateTimeI18n.getFirstDay());
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    public static String encode(String[] strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, strings);
        return builder.toString();
    }
}

