/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.util;

import java.util.Arrays;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.event.PopupFacetActionListener;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CommandRendererHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRendererHelper.class);
    private String onclick;
    private boolean disabled;
    private String href;
    private String target;

    public CommandRendererHelper(FacesContext facesContext, AbstractUICommandBase command) {
        this(facesContext, command, null);
    }

    public CommandRendererHelper(FacesContext facesContext, AbstractUICommandBase base, Tag tag) {
        if (!(base instanceof AbstractUICommand)) {
            return;
        }
        AbstractUICommand command = (AbstractUICommand)base;
        this.disabled = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"disabled");
        if (this.disabled) {
            this.onclick = "";
            this.href = "";
        } else {
            String clientId;
            this.href = "#";
            UIPopup popup = (UIPopup)command.getFacet("popup");
            if (popup != null && !ComponentUtils.containsPopupActionListener((UICommand)command)) {
                command.addActionListener((ActionListener)new PopupFacetActionListener());
            }
            boolean transition = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"transition");
            if (StringUtils.isNotEmpty((String)command.getLink()) || StringUtils.isNotEmpty((String)command.getResource())) {
                String url = RenderUtils.generateUrl((FacesContext)facesContext, (AbstractUICommand)command);
                if (tag == Tag.ANCHOR) {
                    this.onclick = null;
                    this.href = url;
                    this.target = command.getTarget();
                } else {
                    this.onclick = "Tobago.navigateToUrl('" + url + "');";
                }
            } else if (StringUtils.isNotEmpty((String)command.getOnclick())) {
                this.onclick = this.prepareOnClick(facesContext, (AbstractUICommandBase)command);
            } else if (command.getRenderedPartially().length > 0) {
                clientId = command.getClientId(facesContext);
                Object[] componentIds = command.getRenderedPartially();
                boolean popupAction = ComponentUtils.containsPopupActionListener((UICommand)command);
                if (popupAction) {
                    if (componentIds.length != 1) {
                        LOG.warn("more than one partially rendered component is not supported for popup! using first one: " + Arrays.toString(componentIds));
                    }
                    this.onclick = "Tobago.Popup.openWithAction(this, '" + ComponentUtils.evaluateClientId((FacesContext)facesContext, (UIComponent)command, (String)componentIds[0]) + "', '" + clientId + "');";
                } else {
                    this.onclick = "Tobago.reloadComponent(this, '" + HtmlRendererUtils.getComponentIds((FacesContext)facesContext, (UIComponent)command, (String[])componentIds) + "','" + clientId + "', {});";
                }
            } else {
                clientId = command.getClientId(facesContext);
                String t = ComponentUtils.getStringAttribute((UIComponent)command, (String)"target");
                this.onclick = HtmlRendererUtils.createSubmitAction((String)clientId, (boolean)transition, (String)t, null);
            }
            if (command.getAttributes().get("popupClose") != null && ComponentUtils.isInPopup((UIComponent)command)) {
                String value = (String)command.getAttributes().get("popupClose");
                if (value.equals("immediate")) {
                    this.onclick = "Tobago.Popup.close(this);";
                } else if (value.equals("afterSubmit") && command instanceof org.apache.myfaces.tobago.component.UICommand && ((org.apache.myfaces.tobago.component.UICommand)command).getRenderedPartially().length > 0) {
                    this.onclick = "Tobago.Popup.unlockBehind();" + this.onclick + "Tobago.Popup.close(this);";
                }
            }
            this.onclick = this.appendConfirmationScript(this.onclick, (UIComponent)command);
        }
    }

    private String prepareOnClick(FacesContext facesContext, AbstractUICommandBase base) {
        if (!(base instanceof AbstractUICommand)) {
            return null;
        }
        AbstractUICommand command = (AbstractUICommand)base;
        String click = command.getOnclick();
        if (click.contains("@autoId")) {
            click = StringUtils.replace((String)click, (String)"@autoId", (String)command.getClientId(facesContext));
        }
        return click;
    }

    private String appendConfirmationScript(String onclickParameter, UIComponent component) {
        String click = onclickParameter;
        ValueHolder confirmation = (ValueHolder)component.getFacet("confirmation");
        if (confirmation != null) {
            StringBuilder script = new StringBuilder("return confirm('");
            script.append(confirmation.getValue());
            script.append("')");
            if (click != null) {
                script.append(" && ");
                script.append(click);
            }
            click = script.toString();
        }
        return click;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getHref() {
        return this.href;
    }

    public String getTarget() {
        return this.target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        ANCHOR,
        BUTTON;

    }
}

