/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AjaxUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxUtils.class);

    private AjaxUtils() {
    }

    public static boolean isAjaxRequest(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestParameterMap().get("tobago::partialIds") != null;
    }

    public static boolean isAjaxRequest(ServletRequest request) {
        String[] ajaxComponentIds = (String[])request.getParameterMap().get("tobago::partialIds");
        return ajaxComponentIds != null && ajaxComponentIds.length > 0;
    }

    public static void removeAjaxComponent(FacesContext facesContext, String clientId) {
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null) {
            ajaxComponents.remove(clientId);
        }
    }

    public static void addAjaxComponent(FacesContext facesContext, String clientId) {
        AjaxUtils.addAjaxComponent(facesContext, facesContext.getViewRoot().findComponent(clientId));
    }

    public static void addAjaxComponent(FacesContext facesContext, UIComponent component) {
        if (component == null) {
            LOG.warn("Ignore AjaxComponent: null");
            return;
        }
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null) {
            ajaxComponents.put(component.getClientId(facesContext), component);
        }
    }

    public static Set<String> getRequestPartialIds(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get("tobago::partialIds");
        if (ajaxComponentIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(ajaxComponentIds, ",");
            HashSet<String> ajaxComponents = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String ajaxId = tokenizer.nextToken();
                ajaxComponents.add(ajaxId);
            }
            return ajaxComponents;
        }
        return Collections.emptySet();
    }

    public static boolean addUIMessagesToRenderedPartially(FacesContext context) {
        if (!AjaxUtils.isAjaxRequest(context)) {
            return false;
        }
        List<String> list = AjaxInternalUtils.getMessagesComponentIds(context);
        Iterator clientIds = context.getClientIdsWithMessages();
        boolean added = false;
        if (clientIds.hasNext()) {
            for (String componentClientId : list) {
                added = AjaxInternalUtils.addNextPossibleAjaxComponent(context, componentClientId);
            }
        } else {
            for (String componentClientId : list) {
                if (!context.getExternalContext().getRequestParameterMap().containsKey(componentClientId + "::" + "messagesExists")) continue;
                added = AjaxInternalUtils.addNextPossibleAjaxComponent(context, componentClientId);
            }
        }
        return added;
    }

    public static boolean redirect(FacesContext facesContext, String url) throws IOException {
        return AjaxInternalUtils.redirect(facesContext, url);
    }

    public static void redirect(HttpServletResponse response, String url) throws IOException {
        AjaxInternalUtils.redirect(response, url);
    }
}

