/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.myfaces.tobago.internal.layout.BankHead;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.layout.SpanCell;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.layout.Orientation;
import org.apache.myfaces.tobago.layout.RelativeLayoutToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grid {
    private static final Logger LOG = LoggerFactory.getLogger(Grid.class);
    private List<Cell> cells;
    private BankHead[] columnHeads;
    private BankHead[] rowHeads;
    private int columnCount;
    private int rowCount;
    private int columnCursor;
    private int rowCursor;
    private boolean columnOverflow;
    private boolean rowOverflow;
    private List<Integer> errorIndexes;

    public Grid(LayoutTokens columns, LayoutTokens rows) {
        int i;
        assert (columns.getSize() > 0);
        assert (rows.getSize() > 0);
        this.columnCount = columns.getSize();
        this.rowCount = rows.getSize();
        this.columnHeads = new BankHead[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.columnHeads[i] = new BankHead(columns.get(i));
        }
        this.rowHeads = new BankHead[this.rowCount];
        for (i = 0; i < this.rowCount; ++i) {
            this.rowHeads[i] = new BankHead(rows.get(i));
        }
        int size = this.columnCount * this.rowCount;
        this.cells = new ArrayList<Cell>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.cells.add(null);
        }
    }

    public void add(OriginCell cell, int columnSpan, int rowSpan) {
        assert (columnSpan > 0);
        assert (rowSpan > 0);
        boolean error = false;
        if (columnSpan + this.columnCursor > this.columnCount) {
            LOG.warn("The columnSpan is to large for the actual position in the grid. Will be fixed. columnSpan=" + columnSpan + " columnCursor=" + this.columnCursor + " columnCount=" + this.columnCount);
            columnSpan = this.columnCount - this.columnCursor;
            error = true;
        }
        cell.setColumnSpan(columnSpan);
        cell.setRowSpan(rowSpan);
        for (int i = 1; i < columnSpan; ++i) {
            if (this.getCell(i + this.columnCursor, this.rowCursor) == null) continue;
            LOG.warn("The columnSpan is to large for the actual position in the grid. Will be fixed. columnSpan=" + columnSpan + " columnCursor=" + this.columnCursor + " columnCount=" + this.columnCount);
            columnSpan = i - 1;
            error = true;
        }
        for (int j = 0; j < rowSpan; ++j) {
            for (int i = 0; i < columnSpan; ++i) {
                Cell actualCell = i == 0 && j == 0 ? cell : new SpanCell(cell, i == 0, j == 0);
                assert (this.getCell(i + this.columnCursor, j + this.rowCursor) == null) : "Position in the cell must be free.";
                this.setCell(i + this.columnCursor, j + this.rowCursor, actualCell);
                if (!error) continue;
                this.addError(i + this.columnCursor, j + this.rowCursor);
            }
        }
        this.findNextFreeCell();
    }

    public Cell getCell(int i, int j, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.getCell(i, j) : this.getCell(j, i);
    }

    public Cell getCell(int column, int row) {
        assert (column >= 0 && column < this.columnCount) : "column=" + column + " columnCount=" + this.columnCount;
        assert (row >= 0) : "row=" + row;
        if (row >= this.rowCount) {
            return null;
        }
        return this.cells.get(column + row * this.columnCount);
    }

    public void setCell(int column, int row, Cell cell) {
        if (row >= this.rowCount) {
            this.enlarge(row - this.rowCount + 1);
        }
        this.cells.set(column + row * this.columnCount, cell);
    }

    private void findNextFreeCell() {
        while (this.rowCursor < this.rowCount) {
            while (this.columnCursor < this.columnCount) {
                if (this.getCell(this.columnCursor, this.rowCursor) == null) {
                    return;
                }
                ++this.columnCursor;
            }
            this.columnCursor = 0;
            ++this.rowCursor;
        }
    }

    public BankHead[] getBankHeads(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.columnHeads : this.rowHeads;
    }

    private void enlarge(int newRows) {
        for (int i = 0; i < newRows; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                this.cells.add(null);
            }
        }
        BankHead[] newRowHeads = new BankHead[this.rowCount + newRows];
        System.arraycopy(this.rowHeads, 0, newRowHeads, 0, this.rowHeads.length);
        this.rowHeads = newRowHeads;
        for (int i = this.rowCount; i < this.rowCount + newRows; ++i) {
            this.rowHeads[i] = new BankHead(RelativeLayoutToken.DEFAULT_INSTANCE);
        }
        this.rowCount += newRows;
    }

    public boolean isOverflow(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.columnOverflow : this.rowOverflow;
    }

    public void setOverflow(boolean overflow, Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL) {
            this.columnOverflow = overflow;
        } else {
            this.rowOverflow = overflow;
        }
    }

    public boolean isOverflow() {
        return this.columnOverflow;
    }

    public void setColumnOverflow(boolean columnOverflow) {
        this.columnOverflow = columnOverflow;
    }

    public boolean isRowOverflow() {
        return this.rowOverflow;
    }

    public void setRowOverflow(boolean rowOverflow) {
        this.rowOverflow = rowOverflow;
    }

    public void addError(int i, int j) {
        if (this.errorIndexes == null) {
            this.errorIndexes = new ArrayList<Integer>();
        }
        this.errorIndexes.add(j * this.columnCount + i);
    }

    public boolean hasError(int i, int j) {
        if (this.errorIndexes == null) {
            return false;
        }
        return this.errorIndexes.contains(j * this.columnCount + i);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String gridAsString() {
        Cell b;
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                if (this.getCell(i, 0) != null) {
                    builder.append("\u250f");
                } else {
                    builder.append("\u250c");
                }
            } else {
                Cell c = this.getCell(i - 1, 0);
                Cell d = this.getCell(i, 0);
                if (c == null && d == null) {
                    builder.append("\u252c");
                } else if (this.connected(c, d)) {
                    builder.append("\u252f");
                } else if (c == null) {
                    builder.append("\u2532");
                } else if (d == null) {
                    builder.append("\u2531");
                } else {
                    builder.append("\u2533");
                }
            }
            if (this.getCell(i, 0) != null) {
                builder.append("\u2501");
                continue;
            }
            builder.append("\u2500");
        }
        if (this.getCell(this.columnCount - 1, 0) != null) {
            builder.append("\u2513");
        } else {
            builder.append("\u2510");
        }
        builder.append("\n");
        for (int j = 0; j < this.rowCount; ++j) {
            Cell c;
            Cell c2;
            Cell a;
            Cell d;
            if (j != 0) {
                for (int i2 = 0; i2 < this.columnCount; ++i2) {
                    if (i2 == 0) {
                        b = this.getCell(0, j - 1);
                        d = this.getCell(0, j);
                        if (b == null && d == null) {
                            builder.append("\u251c");
                        } else if (this.connected(b, d)) {
                            builder.append("\u2520");
                        } else if (b == null) {
                            builder.append("\u2522");
                        } else if (d == null) {
                            builder.append("\u2521");
                        } else {
                            builder.append("\u2523");
                        }
                    } else {
                        a = this.getCell(i2 - 1, j - 1);
                        Cell b2 = this.getCell(i2, j - 1);
                        Cell c3 = this.getCell(i2 - 1, j);
                        Cell d2 = this.getCell(i2, j);
                        if (this.connected(a, b2)) {
                            if (this.connected(c3, d2)) {
                                if (this.connected(a, c3)) {
                                    builder.append("\u253c");
                                } else {
                                    builder.append("\u253f");
                                }
                            } else {
                                builder.append("\u2548");
                            }
                        } else if (this.connected(c3, d2)) {
                            if (this.connected(a, c3)) {
                                builder.append("\u2544");
                            } else if (this.connected(b2, d2)) {
                                builder.append("\u2543");
                            } else {
                                builder.append("\u2547");
                            }
                        } else if (this.connected(a, c3)) {
                            if (this.connected(b2, d2)) {
                                builder.append("\u2542");
                            } else {
                                builder.append("\u254a");
                            }
                        } else if (this.connected(b2, d2)) {
                            builder.append("\u2549");
                        } else {
                            builder.append("\u254b");
                        }
                    }
                    a = this.getCell(i2, j - 1);
                    c2 = this.getCell(i2, j);
                    if (this.connected(a, c2)) {
                        builder.append("\u2500");
                        continue;
                    }
                    builder.append("\u2501");
                }
                Cell a2 = this.getCell(this.columnCount - 1, j - 1);
                c = this.getCell(this.columnCount - 1, j);
                if (a2 == null && c == null) {
                    builder.append("\u2524");
                } else if (this.connected(a2, c)) {
                    builder.append("\u2528");
                } else if (a2 == null) {
                    builder.append("\u252a");
                } else if (c == null) {
                    builder.append("\u2529");
                } else {
                    builder.append("\u252b");
                }
                builder.append("\n");
            }
            for (int i3 = 0; i3 < this.columnCount; ++i3) {
                if (i3 == 0) {
                    if (this.getCell(i3, j) != null) {
                        builder.append("\u2503");
                    } else {
                        builder.append("\u2502");
                    }
                } else {
                    c = this.getCell(i3 - 1, j);
                    if (this.connected(c, d = this.getCell(i3, j))) {
                        builder.append("\u2502");
                    } else {
                        builder.append("\u2503");
                    }
                }
                if (this.hasError(i3, j)) {
                    builder.append("\u2716");
                    continue;
                }
                if (this.getCell(i3, j) instanceof OriginCell) {
                    builder.append("\u2588");
                    continue;
                }
                if (this.getCell(i3, j) instanceof SpanCell) {
                    if (j == 0) {
                        builder.append("\u279e");
                        continue;
                    }
                    a = this.getCell(i3, j - 1);
                    if (this.connected(a, c2 = this.getCell(i3, j))) {
                        builder.append("\u2b07");
                        continue;
                    }
                    builder.append("\u279e");
                    continue;
                }
                builder.append("\u25cc");
            }
            if (this.getCell(this.columnCount - 1, j) != null) {
                builder.append("\u2503");
            } else {
                builder.append("\u2502");
            }
            builder.append("\n");
        }
        for (i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                if (this.getCell(0, this.rowCount - 1) != null) {
                    builder.append("\u2517");
                } else {
                    builder.append("\u2514");
                }
            } else {
                Cell a = this.getCell(i - 1, this.rowCount - 1);
                b = this.getCell(i, this.rowCount - 1);
                if (a == null && b == null) {
                    builder.append("\u2534");
                } else if (this.connected(a, b)) {
                    builder.append("\u2537");
                } else if (a == null) {
                    builder.append("\u253a");
                } else if (b == null) {
                    builder.append("\u2539");
                } else {
                    builder.append("\u253b");
                }
            }
            if (this.getCell(i, this.rowCount - 1) != null) {
                builder.append("\u2501");
                continue;
            }
            builder.append("\u2500");
        }
        if (this.getCell(this.columnCount - 1, this.rowCount - 1) != null) {
            builder.append("\u251b");
        } else {
            builder.append("\u2518");
        }
        builder.append("\n");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.gridAsString());
        builder.append("columnHeads=");
        builder.append(Arrays.toString(this.columnHeads));
        builder.append("\n");
        builder.append("rowHeads=");
        builder.append(Arrays.toString(this.rowHeads));
        builder.append("\n");
        return builder.toString();
    }

    private boolean connected(Cell a, Cell b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getOrigin().equals(b.getOrigin());
    }
}

