/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIImage;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImageRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String alt;
        String src;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        AbstractUIImage image = (AbstractUIImage)component;
        String value = image.getUrl();
        if (value != null) {
            if (ResourceManagerUtils.isAbsoluteResource((String)value)) {
                src = value;
            } else {
                int dot = ResourceManagerUtils.indexOfExtension((String)value);
                boolean disabled = this.isDisabled(image);
                src = dot != -1 ? ResourceManagerUtils.getImageOrDisabledImageWithPath((FacesContext)facesContext, (String)value, (boolean)disabled) : ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)value, (boolean)disabled);
            }
        } else {
            src = null;
        }
        String border = (String)image.getAttributes().get("border");
        if (border == null) {
            border = "0";
        }
        if ((alt = (String)image.getAttributes().get("alt")) == null) {
            alt = "";
        }
        writer.startElement("img", (UIComponent)image);
        String clientId = image.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)image);
        if (src != null) {
            writer.writeAttribute("src", src, true);
        }
        writer.writeAttribute("alt", alt, true);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)image);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.writeAttribute("border", border, false);
        Style style = new Style(facesContext, (LayoutBase)image);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)image));
        writer.endElement("img");
    }

    private String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn("Image src without extension: '" + src + "'");
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    private boolean isDisabled(AbstractUIImage graphic) {
        return graphic.isDisabled() || graphic.getParent() instanceof UICommand && ((UICommand)graphic.getParent()).isDisabled();
    }
}

