/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIIn;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RichTextEditorRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(RichTextEditorRenderer.class);
    public static final String CHANGE_BUTTON = "togleState";

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        super.decode(facesContext, component);
        String actionId = ComponentUtils.findPage((FacesContext)facesContext, (UIComponent)component).getActionId();
        if (actionId != null && actionId.equals(component.getClientId(facesContext) + CHANGE_BUTTON)) {
            boolean state = ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"statePreview");
            component.getAttributes().put("statePreview", !state);
            facesContext.renderResponse();
        }
        ((EditableValueHolder)component).setValid(true);
    }

    public static String contentToHtml(String content) {
        try {
            LOG.warn("richtext switched off, because of dependencies");
            return content;
        }
        catch (Exception e) {
            LOG.error("failed to parser wiki markup", (Throwable)e);
            return content;
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIIn input = (UIIn)component;
        boolean previewState = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"statePreview");
        String clientId = input.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)input);
        writer.writeClassAttribute(Classes.create((UIComponent)input, (String)"container"));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)input);
        Style style = new Style(facesContext, (LayoutBase)input);
        writer.writeStyleAttribute(style);
        UIComponent toolbar = input.getFacet("toolBar");
        if (toolbar == null) {
            toolbar = this.createToolbar(facesContext, input);
        }
        facesContext.getExternalContext().getRequestMap().put("tobagoRichtextPreviewState", previewState ? Boolean.TRUE : Boolean.FALSE);
        RenderUtils.encode((FacesContext)facesContext, (UIComponent)toolbar);
        String content = this.getCurrentValue(facesContext, (UIComponent)input);
        if (previewState) {
            writer.startElement("input", (UIComponent)input);
            writer.writeAttribute("type", "hidden", false);
            writer.writeNameAttribute(clientId);
            writer.writeAttribute("value", content, true);
            writer.endElement("input");
            writer.startElement("div", (UIComponent)input);
            writer.writeClassAttribute(Classes.create((UIComponent)input, (String)"body"));
            writer.writeIdAttribute(clientId);
            writer.writeStyleAttribute(style);
            writer.flush();
            writer.write(RichTextEditorRenderer.contentToHtml(content));
            writer.endElement("div");
        } else {
            writer.startElement("textarea", (UIComponent)input);
            writer.writeClassAttribute(Classes.create((UIComponent)input, (String)"body"));
            writer.writeNameAttribute(clientId);
            writer.writeIdAttribute(clientId);
            writer.writeStyleAttribute(style);
            String onchange = HtmlUtils.generateOnchange((UIInput)input, (FacesContext)facesContext);
            if (null != onchange) {
                writer.writeAttribute("onchange", (Object)onchange, null);
            }
            if (content != null) {
                writer.writeText(content);
            }
            writer.endElement("textarea");
        }
        writer.endElement("div");
    }

    private UIComponent createToolbar(FacesContext facesContext, UIIn component) {
        UIPanel toolbar = (UIPanel)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"javax.faces.Panel", (String)"ToolBar");
        String clientId = component.getClientId(facesContext);
        component.getFacets().put("toolBar", toolbar);
        toolbar.getAttributes().put("iconSize", "small");
        toolbar.getAttributes().put("labelPosition", "off");
        UICommand command = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.SelectBooleanCommand", (String)"MenuCommand");
        toolbar.getChildren().add(command);
        command.getAttributes().put("image", "image/tobago-richtext-edit.gif");
        command.setValueBinding("disabled", ComponentUtils.createValueBinding((String)"#{! tobagoRichtextPreviewState}"));
        command.setValueBinding("value", ComponentUtils.createValueBinding((String)"#{!tobagoRichtextPreviewState}"));
        String title = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.richtexteditor.edit.title");
        command.getAttributes().put("tip", title);
        String onClick = HtmlRendererUtils.createSubmitAction((String)(clientId + CHANGE_BUTTON), (boolean)true, null, null);
        command.getAttributes().put("onclick", onClick);
        command = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.SelectBooleanCommand", (String)"MenuCommand");
        toolbar.getChildren().add(command);
        command.getAttributes().put("image", "image/tobago-richtext-preview.gif");
        command.setValueBinding("disabled", ComponentUtils.createValueBinding((String)"#{tobagoRichtextPreviewState}"));
        command.setValueBinding("value", ComponentUtils.createValueBinding((String)"#{tobagoRichtextPreviewState}"));
        title = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.richtexteditor.preview.title");
        command.getAttributes().put("tip", title);
        command.getAttributes().put("onclick", onClick);
        command = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", (String)"MenuCommand");
        toolbar.getChildren().add(command);
        command.getAttributes().put("image", "image/config.gif");
        return toolbar;
    }
}

