/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.renderkit.css.Overflow;
import org.apache.myfaces.tobago.renderkit.css.Position;

public class Style
implements Serializable {
    private static final long serialVersionUID = 4L;
    private Measure width;
    private Measure height;
    private Measure left;
    private Measure top;
    private Display display;
    private Position position;
    private Overflow overflowX;
    private Overflow overflowY;
    private Measure marginLeft;
    private Measure marginRight;
    private Measure marginTop;
    private Measure marginBottom;
    private Measure margin;
    private Measure paddingLeft;
    private Measure paddingRight;
    private Measure paddingTop;
    private Measure paddingBottom;
    private Measure padding;
    private String backgroundImage;
    private String backgroundPosition;
    private Integer zIndex;
    private TextAlign textAlign;

    public Style() {
    }

    public Style(Style map) {
        this.width = map.width;
        this.height = map.height;
        this.left = map.left;
        this.top = map.top;
        this.display = map.display;
        this.position = map.position;
        this.overflowX = map.overflowX;
        this.overflowY = map.overflowY;
        this.marginLeft = map.marginLeft;
        this.marginRight = map.marginRight;
        this.marginTop = map.marginTop;
        this.marginBottom = map.marginBottom;
        this.margin = map.margin;
        this.paddingLeft = map.paddingLeft;
        this.paddingRight = map.paddingRight;
        this.paddingTop = map.paddingTop;
        this.paddingBottom = map.paddingBottom;
        this.padding = map.padding;
        this.backgroundImage = map.backgroundImage;
        this.backgroundPosition = map.backgroundPosition;
        this.zIndex = map.zIndex;
        this.textAlign = map.textAlign;
    }

    public Style(FacesContext facesContext, LayoutBase layout) {
        String rendererType = layout.getRendererType();
        this.width = layout.getCurrentWidth();
        if (this.width != null) {
            this.width = this.width.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.border-left-width"));
            this.width = this.width.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.padding-left"));
            this.width = this.width.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.padding-right"));
            this.width = this.width.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.border-right-width"));
        }
        this.height = layout.getCurrentHeight();
        if (this.height != null) {
            this.height = this.height.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.border-top-width"));
            this.height = this.height.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.padding-top"));
            this.height = this.height.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.padding-bottom"));
            this.height = this.height.subtractNotNegative(ResourceManagerUtils.getThemeMeasure(facesContext, layout, "css.border-bottom-width"));
        }
        this.left = layout.getLeft();
        this.top = layout.getTop();
        if (!(this.left == null && this.top == null || rendererType.contains("Page"))) {
            this.position = Position.ABSOLUTE;
        }
        if (layout instanceof LayoutComponent) {
            this.display = ((LayoutComponent)layout).getDisplay();
        }
        if (layout instanceof LayoutContainer) {
            this.overflowX = ((LayoutContainer)layout).isOverflowX() ? Overflow.AUTO : null;
            this.overflowY = ((LayoutContainer)layout).isOverflowY() ? Overflow.AUTO : null;
        }
    }

    public boolean needsToBeEscaped() {
        return this.backgroundImage != null;
    }

    public String encode() {
        StringBuilder buf = new StringBuilder();
        if (this.width != null) {
            buf.append("width:");
            buf.append(this.width.serialize());
            buf.append(';');
        }
        if (this.height != null) {
            buf.append("height:");
            buf.append(this.height.serialize());
            buf.append(';');
        }
        if (this.top != null) {
            buf.append("top:");
            buf.append(this.top.serialize());
            buf.append(';');
        }
        if (this.left != null) {
            buf.append("left:");
            buf.append(this.left.serialize());
            buf.append(';');
        }
        if (this.display != null) {
            buf.append("display:");
            buf.append(this.display.getValue());
            buf.append(';');
        }
        if (this.position != null) {
            buf.append("position:");
            buf.append(this.position.getValue());
            buf.append(';');
        }
        if (this.overflowX != null) {
            buf.append("overflow-x:");
            buf.append(this.overflowX.getValue());
            buf.append(';');
        }
        if (this.overflowY != null) {
            buf.append("overflow-y:");
            buf.append(this.overflowY.getValue());
            buf.append(';');
        }
        if (this.marginLeft != null) {
            buf.append("margin-left:");
            buf.append(this.marginLeft.serialize());
            buf.append(';');
        }
        if (this.marginRight != null) {
            buf.append("margin-right:");
            buf.append(this.marginRight.serialize());
            buf.append(';');
        }
        if (this.marginTop != null) {
            buf.append("margin-top:");
            buf.append(this.marginTop.serialize());
            buf.append(';');
        }
        if (this.marginBottom != null) {
            buf.append("margin-bottom:");
            buf.append(this.marginBottom.serialize());
            buf.append(';');
        }
        if (this.margin != null) {
            buf.append("margin:");
            buf.append(this.margin.serialize());
            buf.append(';');
        }
        if (this.paddingLeft != null) {
            buf.append("padding-left:");
            buf.append(this.paddingLeft.serialize());
            buf.append(';');
        }
        if (this.paddingRight != null) {
            buf.append("padding-right:");
            buf.append(this.paddingRight.serialize());
            buf.append(';');
        }
        if (this.paddingTop != null) {
            buf.append("padding-top:");
            buf.append(this.paddingTop.serialize());
            buf.append(';');
        }
        if (this.paddingBottom != null) {
            buf.append("padding-bottom:");
            buf.append(this.paddingBottom.serialize());
            buf.append(';');
        }
        if (this.padding != null) {
            buf.append("padding:");
            buf.append(this.padding.serialize());
            buf.append(';');
        }
        if (this.backgroundImage != null) {
            buf.append("background-image:");
            buf.append(this.backgroundImage);
            buf.append(';');
        }
        if (this.backgroundPosition != null) {
            buf.append("background-position:");
            buf.append(this.backgroundPosition);
            buf.append(';');
        }
        if (this.zIndex != null) {
            buf.append("z-index:");
            buf.append(this.zIndex);
            buf.append(';');
        }
        if (this.textAlign != null) {
            buf.append("text-align:");
            buf.append(this.textAlign.getValue());
            buf.append(';');
        }
        return buf.toString();
    }

    public String encodeJson() {
        StringBuilder buf = new StringBuilder("{");
        if (this.width != null) {
            buf.append("\"width\":\"");
            buf.append(this.width.serialize());
            buf.append("\",");
        }
        if (this.height != null) {
            buf.append("\"height\":\"");
            buf.append(this.height.serialize());
            buf.append("\",");
        }
        if (this.top != null) {
            buf.append("\"top\":\"");
            buf.append(this.top.serialize());
            buf.append("\",");
        }
        if (this.left != null) {
            buf.append("\"left\":\"");
            buf.append(this.left.serialize());
            buf.append("\",");
        }
        if (this.display != null) {
            buf.append("\"display\":\"");
            buf.append(this.display.getValue());
            buf.append("\",");
        }
        if (this.position != null) {
            buf.append("\"position\":\"");
            buf.append(this.position.getValue());
            buf.append("\",");
        }
        if (this.overflowX != null) {
            buf.append("\"overflowX\":\"");
            buf.append(this.overflowX.getValue());
            buf.append("\",");
        }
        if (this.overflowY != null) {
            buf.append("\"overflowY\":\"");
            buf.append(this.overflowY.getValue());
            buf.append("\",");
        }
        if (this.marginLeft != null) {
            buf.append("\"marginLeft\":\"");
            buf.append(this.marginLeft.serialize());
            buf.append("\",");
        }
        if (this.marginRight != null) {
            buf.append("\"marginRight\":\"");
            buf.append(this.marginRight.serialize());
            buf.append("\",");
        }
        if (this.marginTop != null) {
            buf.append("\"marginTop\":\"");
            buf.append(this.marginTop.serialize());
            buf.append("\",");
        }
        if (this.marginBottom != null) {
            buf.append("\"marginBottom\":\"");
            buf.append(this.marginBottom.serialize());
            buf.append("\",");
        }
        if (this.margin != null) {
            buf.append("\"margin\":\"");
            buf.append(this.margin.serialize());
            buf.append("\",");
        }
        if (this.paddingLeft != null) {
            buf.append("\"paddingLeft\":\"");
            buf.append(this.paddingLeft.serialize());
            buf.append("\",");
        }
        if (this.paddingRight != null) {
            buf.append("\"paddingRight\":\"");
            buf.append(this.paddingRight.serialize());
            buf.append("\",");
        }
        if (this.paddingTop != null) {
            buf.append("\"paddingTop\":\"");
            buf.append(this.paddingTop.serialize());
            buf.append("\",");
        }
        if (this.paddingBottom != null) {
            buf.append("\"paddingBottom\":\"");
            buf.append(this.paddingBottom.serialize());
            buf.append("\",");
        }
        if (this.padding != null) {
            buf.append("\"padding\":\"");
            buf.append(this.padding.serialize());
            buf.append("\",");
        }
        if (this.backgroundImage != null) {
            buf.append("\"backgroundImage\":\"");
            buf.append(this.backgroundImage);
            buf.append("\",");
        }
        if (this.backgroundPosition != null) {
            buf.append("\"backgroundPosition\":\"");
            buf.append(this.backgroundPosition);
            buf.append("\",");
        }
        if (this.zIndex != null) {
            buf.append("\"zIndex\":");
            buf.append(this.zIndex);
            buf.append(";");
        }
        if (this.textAlign != null) {
            buf.append("\"textAlign\":\"");
            buf.append(this.textAlign.getValue());
            buf.append("\",");
        }
        if (buf.length() > 1) {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append('}');
        return buf.toString();
    }

    public Measure getWidth() {
        return this.width;
    }

    public void setWidth(Measure width) {
        this.width = width;
    }

    public Measure getHeight() {
        return this.height;
    }

    public void setHeight(Measure height) {
        this.height = height;
    }

    public Measure getLeft() {
        return this.left;
    }

    public void setLeft(Measure left) {
        this.left = left;
    }

    public Measure getTop() {
        return this.top;
    }

    public void setTop(Measure top) {
        this.top = top;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Overflow getOverflowX() {
        return this.overflowX;
    }

    public void setOverflowX(Overflow overflowX) {
        this.overflowX = overflowX;
    }

    public Overflow getOverflowY() {
        return this.overflowY;
    }

    public void setOverflowY(Overflow overflowY) {
        this.overflowY = overflowY;
    }

    public Measure getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(Measure marginLeft) {
        this.marginLeft = marginLeft;
    }

    public Measure getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(Measure marginRight) {
        this.marginRight = marginRight;
    }

    public Measure getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(Measure marginTop) {
        this.marginTop = marginTop;
    }

    public Measure getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(Measure marginBottom) {
        this.marginBottom = marginBottom;
    }

    public Measure getMargin() {
        return this.margin;
    }

    public void setMargin(Measure margin) {
        this.margin = margin;
    }

    public Measure getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(Measure paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public Measure getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(Measure paddingRight) {
        this.paddingRight = paddingRight;
    }

    public Measure getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(Measure paddingTop) {
        this.paddingTop = paddingTop;
    }

    public Measure getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(Measure paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public Measure getPadding() {
        return this.padding;
    }

    public void setPadding(Measure padding) {
        this.padding = padding;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public String getBackgroundPosition() {
        return this.backgroundPosition;
    }

    public void setBackgroundPosition(String backgroundPosition) {
        this.backgroundPosition = backgroundPosition;
    }

    public Integer getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(Integer zIndex) {
        this.zIndex = zIndex;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }
}

