/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Selectable {
    NONE("none"),
    MULTI("multi"),
    SINGLE("single"),
    SINGLE_OR_NONE("singleOrNone"),
    MULTI_LEAF_ONLY("multiLeafOnly"),
    SINGLE_LEAF_ONLY("singleLeafOnly"),
    SIBLING("sibling"),
    SIBLING_LEAF_ONLY("siblingLeafOnly"),
    MULTI_CASCADE("multiCascade");

    private static final Set<Selectable> SHEET_VALUES;
    private static final Set<Selectable> TREE_VALUES;
    private static final Set<Selectable> TREE_LISTBOX_VALUES;
    private static final Map<String, Selectable> MAPPING;
    private String value;

    private Selectable(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Selectable parse(Object name) throws IllegalArgumentException {
        if (name == null) {
            return null;
        }
        if (name instanceof Selectable) {
            return (Selectable)((Object)name);
        }
        Selectable value = MAPPING.get(name.toString());
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Unknown name for TreeSelectable: '" + name + "'");
    }

    public boolean isLeafOnly() {
        return this == SINGLE_LEAF_ONLY || this == MULTI_LEAF_ONLY || this == SIBLING_LEAF_ONLY;
    }

    public boolean isSingle() {
        return this == SINGLE || this == SINGLE_OR_NONE || this == SINGLE_LEAF_ONLY;
    }

    public boolean isSupportedBySheet() {
        return SHEET_VALUES.contains((Object)this);
    }

    public boolean isSupportedByTree() {
        return TREE_VALUES.contains((Object)this);
    }

    public boolean isSupportedByTreeListbox() {
        return TREE_LISTBOX_VALUES.contains((Object)this);
    }

    static {
        SHEET_VALUES = EnumSet.of(NONE, MULTI, SINGLE, SINGLE_OR_NONE);
        TREE_VALUES = EnumSet.of(NONE, new Selectable[]{MULTI, SINGLE, MULTI_LEAF_ONLY, SINGLE_LEAF_ONLY, MULTI_CASCADE});
        TREE_LISTBOX_VALUES = EnumSet.of(SINGLE, SINGLE_LEAF_ONLY, MULTI_LEAF_ONLY);
        MAPPING = new HashMap<String, Selectable>();
        for (Selectable action : Selectable.values()) {
            MAPPING.put(action.getValue(), action);
        }
    }
}

