/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.FastStringWriter;
import org.apache.myfaces.tobago.internal.util.JavascriptWriterUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.webapp.HtmlResponseWriter;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResponseWriter
extends HtmlResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonResponseWriter.class);
    private Writer javascriptWriter = new FastStringWriter();
    private boolean javascriptBlock;
    private JavascriptWriterUtils encodeInJavascriptBlock;
    private JavascriptWriterUtils encodeOutsideJavascriptBlock;

    public JsonResponseWriter(Writer writer, String contentType, String characterEncoding) {
        super(writer, contentType, characterEncoding);
        this.encodeOutsideJavascriptBlock = new JavascriptWriterUtils(writer, characterEncoding);
        this.encodeInJavascriptBlock = new JavascriptWriterUtils(this.javascriptWriter, characterEncoding);
    }

    public void endJavascript() throws IOException {
        this.javascriptBlock = false;
    }

    public void startJavascript() throws IOException {
        this.javascriptBlock = true;
    }

    public void write(String string) throws IOException {
        this.closeOpenTag();
        if (FacesVersion.isMojarra() && FacesVersion.supports21() && "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".equals(string)) {
            return;
        }
        if (this.javascriptBlock) {
            this.encodeInJavascriptBlock.writeText(string);
        } else {
            this.encodeOutsideJavascriptBlock.writeText(string);
        }
    }

    public void write(char[] chars) throws IOException {
        StackTraceElement[] stackTraceElements;
        if (FacesVersion.isMojarra() && FacesVersion.supports20() && (stackTraceElements = Thread.currentThread().getStackTrace())[2].getClassName().equals("com.sun.faces.renderkit.ServerSideStateHelper")) {
            super.write(StringUtils.replace(new String(chars), "\"", "\\\""));
            return;
        }
        super.write(chars);
    }

    public void writeJavascript(String script) throws IOException {
        this.closeOpenTag();
        this.encodeInJavascriptBlock.writeText(script);
    }

    public String getJavascript() {
        return this.javascriptWriter.toString();
    }

    protected void startElementInternal(Writer writer, String name, UIComponent currentComponent) throws IOException {
        this.setComponent(currentComponent);
        if (this.isStartStillOpen()) {
            writer.write(">");
        }
        writer.write("<");
        writer.write(name);
        this.setStartStillOpen(true);
    }

    protected void endElementInternal(Writer writer, String name) throws IOException {
        if (EMPTY_TAG.contains(name)) {
            writer.write(">");
        } else {
            if (this.isStartStillOpen()) {
                writer.write(">");
            }
            writer.write("</");
            writer.write(name);
            writer.write(">");
        }
        this.setStartStillOpen(false);
    }

    protected void closeOpenTag() throws IOException {
        if (this.isStartStillOpen()) {
            this.getWriter().write(">");
            this.setStartStillOpen(false);
        }
    }

    protected void writeAttributeInternal(Writer writer, String name, String value, boolean escape) throws IOException {
        if (!this.isStartStillOpen()) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + name + "' value = '" + value + "' " + trace.substring(trace.indexOf(40));
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        if (value != null) {
            writer.write(32);
            writer.write(name);
            writer.write("='");
            if (escape) {
                this.getHelper().writeAttributeValue(value);
            } else {
                writer.write(value);
            }
            writer.write("'");
        }
    }

    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        this.getHelper().writeText(value);
    }

    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new JsonResponseWriter(originalWriter, this.getContentType(), this.getCharacterEncoding());
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }
}

