/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugResponseWriterWrapper
extends TobagoResponseWriter {
    private Stack<String> stack = new Stack();
    private static final Logger LOG = LoggerFactory.getLogger(DebugResponseWriterWrapper.class);
    private final TobagoResponseWriter responseWriter;

    public DebugResponseWriterWrapper(TobagoResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public void write(String string) throws IOException {
        this.responseWriter.write(string);
    }

    public void writeComment(Object comment) throws IOException {
        String commentStr = comment.toString();
        if (commentStr.indexOf("--") > 0) {
            LOG.error("Comment must not contain the sequence '--', comment = '" + comment + "'.", (Throwable)new IllegalArgumentException());
            commentStr = StringUtils.replace(commentStr, "--", "++");
        }
        this.responseWriter.writeComment(commentStr);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new DebugResponseWriterWrapper((TobagoResponseWriter)this.responseWriter.cloneWithWriter(writer));
    }

    @Deprecated
    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.responseWriter.writeAttribute(name, value, property);
    }

    @Deprecated
    public void writeText(Object text, String property) throws IOException {
        this.responseWriter.writeText(text, property);
    }

    public void flush() throws IOException {
        this.responseWriter.flush();
    }

    public void writeAttribute(String name, String value, boolean escape) throws IOException {
        this.responseWriter.writeAttribute(name, value, escape);
    }

    @Deprecated
    public String getStyleClasses() {
        return this.responseWriter.getStyleClasses();
    }

    @Deprecated
    public void writeClassAttribute() throws IOException {
        Deprecation.LOG.warn("Please use writeClassAttribute(org.apache.myfaces.tobago.renderkit.css.Classes)");
        this.responseWriter.writeAttribute("class", null, "styleClass");
    }

    public String getContentType() {
        return this.responseWriter.getContentType();
    }

    public String getCharacterEncoding() {
        return this.responseWriter.getCharacterEncoding();
    }

    public void startDocument() throws IOException {
        this.responseWriter.startDocument();
    }

    public void endDocument() throws IOException {
        this.responseWriter.endDocument();
    }

    @Deprecated
    public void writeJavascript(String script) throws IOException {
        this.responseWriter.writeJavascript(script);
    }

    @Deprecated
    public void endJavascript() throws IOException {
        this.responseWriter.endJavascript();
    }

    @Deprecated
    public void startJavascript() throws IOException {
        this.responseWriter.startJavascript();
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.responseWriter.writeURIAttribute(name, value, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.responseWriter.writeText(text, off, len);
    }

    public void write(char[] chars, int i, int i1) throws IOException {
        this.responseWriter.write(chars, i, i1);
    }

    public void close() throws IOException {
        this.responseWriter.close();
    }

    public void startElement(String name, UIComponent currentComponent) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("start element: '" + name + "'");
        }
        this.stack.push(name);
        this.responseWriter.startElement(name, currentComponent);
    }

    public void endElement(String name) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("end element: '" + name + "'");
        }
        String top = "";
        try {
            top = this.stack.pop();
        }
        catch (EmptyStackException e) {
            LOG.error("Failed to close element \"" + name + "\"!", (Throwable)e);
        }
        if (!top.equals(name)) {
            LOG.error("Element end with name='" + name + "' doesn't match with top element on the stack='" + top + "'.", (Throwable)new IllegalArgumentException());
        }
        this.responseWriter.endElement(name);
    }
}

