/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static List<Integer> parseIntegerList(String integerList) throws NumberFormatException {
        return StringUtils.parseIntegerList(integerList, ", ");
    }

    public static List<Integer> parseIntegerList(String integerList, String delimiters) throws NumberFormatException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(integerList, delimiters);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            list.add(new Integer(token));
        }
        return list;
    }

    public static <T> String joinWithSurroundingSeparator(List<T> list) {
        StringBuilder buffer = new StringBuilder(",");
        if (list != null) {
            for (T t : list) {
                buffer.append(t);
                buffer.append(",");
            }
        }
        return buffer.toString();
    }

    public static int[] getIndices(String list) {
        ArrayList<String> indexList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            int i;
            int end;
            String token = st.nextToken().trim();
            int idx = token.indexOf(45);
            if (idx == -1) {
                indexList.add(token);
                continue;
            }
            int start = Integer.parseInt(token.substring(0, idx).trim());
            if (start < (end = Integer.parseInt(token.substring(idx + 1).trim()))) {
                for (i = start; i < end + 1; ++i) {
                    indexList.add(Integer.toString(i));
                }
                continue;
            }
            for (i = start; i > end - 1; --i) {
                indexList.add(Integer.toString(i));
            }
        }
        int[] indices = new int[indexList.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = Integer.parseInt((String)indexList.get(i));
        }
        return indices;
    }

    public static String constantToCamelCase(String constant) {
        StringBuilder builder = new StringBuilder(constant.length());
        char[] chars = constant.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0) {
                builder.append(chars[i]);
                continue;
            }
            if (chars[i] == '_') {
                builder.append(chars[++i]);
                continue;
            }
            builder.append(Character.valueOf(chars[i]).toString().toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    public static boolean equalsIgnoreCaseAndWhitespace(String type1, String type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        char[] chars1 = type1.toCharArray();
        char[] chars2 = type2.toCharArray();
        int length1 = chars1.length;
        int length = chars2.length;
        int i = 0;
        int j = 0;
        while (i < length1 && j < length) {
            if (chars1[i] == chars2[j] || Character.toUpperCase(chars1[i]) == Character.toUpperCase(chars2[j])) {
                ++i;
                ++j;
                continue;
            }
            if (Character.isWhitespace(chars1[i])) {
                ++i;
                continue;
            }
            if (Character.isWhitespace(chars2[j])) {
                ++j;
                continue;
            }
            return false;
        }
        while (i < length1) {
            if (Character.isWhitespace(chars1[i])) {
                ++i;
                continue;
            }
            return false;
        }
        while (j < length) {
            if (Character.isWhitespace(chars2[j])) {
                ++j;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean endsWith(String string, String suffix) {
        if (string == null || suffix == null) {
            return string == null && suffix == null;
        }
        if (suffix.length() > string.length()) {
            return false;
        }
        int strOffset = string.length() - suffix.length();
        return string.regionMatches(false, strOffset, suffix, 0, suffix.length());
    }

    public static String[] split(String string, char separator) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (string.charAt(i) == separator) {
                if (match) {
                    list.add(string.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(string.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String string, String separator) {
        int max = -1;
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separator == null) {
            while (i < len) {
                if (Character.isWhitespace(string.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == -1) {
                            i = len;
                        }
                        list.add(string.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separator.length() == 1) {
            char sep = separator.charAt(0);
            while (i < len) {
                if (string.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == -1) {
                            i = len;
                        }
                        list.add(string.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separator.indexOf(string.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == -1) {
                            i = len;
                        }
                        list.add(string.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(string.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean isAlpha(String string) {
        if (string == null) {
            return false;
        }
        int sz = string.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        int strLen = string.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String replace(String text, String searchString, String replacement) {
        int max = -1;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String repeat(String str, int repeat) {
        int outputLength = str.length() * repeat;
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String toConfidentialString(String string, boolean confidential) {
        if (string == null) {
            return "<null>";
        }
        if (confidential) {
            return StringUtils.repeat("*", string.length()) + " (confidential)";
        }
        return string;
    }

    public static String uncapitalize(String str) {
        return String.valueOf(Character.toLowerCase(str.charAt(0))) + str.substring(1);
    }

    public static boolean isAlphanumeric(String str) {
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(List<String> list, char separator) {
        int size = list.size();
        if (size <= 0) {
            return "";
        }
        int bufSize = size * list.get(0).length() + 1;
        StringBuilder builder = new StringBuilder(bufSize);
        for (int i = 0; i < size; ++i) {
            String string;
            if (i > 0) {
                builder.append(separator);
            }
            if ((string = list.get(i)) == null) continue;
            builder.append(string);
        }
        return builder.toString();
    }

    public static String defaultString(String string) {
        return string == null ? "" : string;
    }

    public static boolean notEquals(String a, String b) {
        return a == null ? b != null : !a.equals(b);
    }

    public static boolean isUrl(String link) {
        if (link == null) {
            return false;
        }
        int colon = link.indexOf(58);
        if (colon < 1) {
            return false;
        }
        for (int i = 0; i < colon; ++i) {
            if (Character.isLetter(link.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

