/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigEntityResolver;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigVersion;
import org.apache.myfaces.tobago.internal.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TobagoConfigParser
extends TobagoConfigEntityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigParser.class);
    private static final int TOBAGO_CONFIG = -1498874611;
    private static final int NAME = 3373707;
    private static final int ORDERING = 1234314708;
    private static final int BEFORE = -1392885889;
    private static final int AFTER = 92734940;
    private static final int THEME_CONFIG = 1930630086;
    private static final int DEFAULT_THEME = -114431171;
    private static final int SUPPORTED_THEME = -822303766;
    private static final int RESOURCE_DIR = -385546674;
    private static final int CREATE_SESSION_SECRET = 413906616;
    private static final int CHECK_SESSION_SECRET = 275994924;
    private static final int PREVENT_FRAME_ATTACKS = 270456726;
    private static final int SET_NOSNIFF_HEADER = -1238451304;
    private static final int CONTENT_SECURITY_POLICY = 1207440139;
    private static final int DIRECTIVE = -962590641;
    private static final int RENDERERS = 1839650832;
    private static final int RENDERER = -494845757;
    private static final int SUPPORTED_MARKUP = 71904295;
    private static final int MARKUP = -1081305560;
    private static final int THEME_DEFINITIONS = -255617156;
    private static final int THEME_DEFINITION = 1515774935;
    private static final int DISPLAY_NAME = 1568910518;
    private static final int RESOURCE_PATH = 933304964;
    private static final int FALLBACK = 761243362;
    private static final int VERSIONED = -1407102089;
    private static final int RESOURCES = -1983070683;
    private static final int EXCLUDES = 1994055129;
    private static final int SANITIZER = 1807639849;
    private static final int SANITIZER_CLASS = -974266412;
    private static final int SCRIPT = -907685685;
    private static final int STYLE = 109780401;
    private static final int PROPERTIES = -926053069;
    private static final int ENTRY = 96667762;
    private static final int AUTO_ACCESS_KEY_FROM_LABEL = 2070339882;
    private static final int CLASSIC_DATE_TIME_PICKER = -879394870;
    private static final int MIME_TYPES = 1081186720;
    private static final int MIME_TYPE = -242217677;
    private static final int EXTENSION = -612557761;
    private static final int TYPE = 3575610;
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_PRODUCTION = "production";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_PRIORITY = "priority";
    private static final int MAX_PRIORITY = 65536;
    private TobagoConfigFragment tobagoConfig;
    private RendererConfig currentRenderer;
    private ThemeImpl currentTheme;
    private Boolean production;
    private boolean exclude;
    private StringBuilder buffer;
    private Properties properties;
    private String entryKey;
    private String extension;
    private String type;
    private Stack<String> stack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TobagoConfigFragment parse(URL url) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        TobagoConfigVersion version;
        if (LOG.isInfoEnabled()) {
            LOG.info("Parsing configuration file: '{}'", (Object)url);
        }
        if ((version = new TobagoConfigVersion(url)).isSchema()) {
            this.validate(url, version);
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (!version.isSchema()) {
                factory.setValidating(true);
            }
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(inputStream, (DefaultHandler)this);
        }
        finally {
            IoUtils.closeQuietly(inputStream);
        }
        return this.tobagoConfig;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    public void startDocument() throws SAXException {
        this.buffer = new StringBuilder();
        this.stack = new Stack();
    }

    public void endDocument() throws SAXException {
        assert (this.stack.empty());
        this.stack = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        assert (this.buffer.toString().trim().length() == 0);
        this.buffer.setLength(0);
        this.stack.add(qName);
        switch (qName.hashCode()) {
            case -1498874611: {
                this.tobagoConfig = new TobagoConfigFragment();
                break;
            }
            case 1207440139: {
                String mode = attributes.getValue(ATTR_MODE);
                this.tobagoConfig.setContentSecurityPolicy(new ContentSecurityPolicy(mode));
                break;
            }
            case 1839650832: {
                if (this.currentTheme != null) {
                    this.currentTheme.setRenderersConfig(new RenderersConfigImpl());
                    break;
                }
                this.tobagoConfig.setRenderersConfig(new RenderersConfigImpl());
                break;
            }
            case -494845757: {
                this.currentRenderer = new RendererConfig();
                break;
            }
            case 1515774935: {
                this.currentTheme = new ThemeImpl();
                this.tobagoConfig.addThemeDefinition(this.currentTheme);
                break;
            }
            case -1983070683: {
                this.production = Boolean.parseBoolean(attributes.getValue(ATTR_PRODUCTION));
                break;
            }
            case 1994055129: {
                this.exclude = true;
                break;
            }
            case -907685685: {
                ThemeScript script = new ThemeScript();
                script.setName(attributes.getValue(ATTR_NAME));
                String scriptPriority = attributes.getValue(ATTR_PRIORITY);
                script.setPriority(scriptPriority != null ? Integer.parseInt(scriptPriority) : 65536);
                if (this.production.booleanValue()) {
                    this.currentTheme.getProductionResources().addScript(script, this.exclude);
                    break;
                }
                this.currentTheme.getResources().addScript(script, this.exclude);
                break;
            }
            case 109780401: {
                ThemeStyle style = new ThemeStyle();
                style.setName(attributes.getValue(ATTR_NAME));
                String stylePriority = attributes.getValue(ATTR_PRIORITY);
                style.setPriority(stylePriority != null ? Integer.parseInt(stylePriority) : 65536);
                if (this.production.booleanValue()) {
                    this.currentTheme.getProductionResources().addStyle(style, this.exclude);
                    break;
                }
                this.currentTheme.getResources().addStyle(style, this.exclude);
                break;
            }
            case -926053069: {
                this.properties = new Properties();
                break;
            }
            case 96667762: {
                this.entryKey = attributes.getValue(ATTR_KEY);
                break;
            }
            case -1407102089: 
            case -1392885889: 
            case -1238451304: 
            case -1081305560: 
            case -974266412: 
            case -962590641: 
            case -879394870: 
            case -822303766: 
            case -612557761: 
            case -385546674: 
            case -255617156: 
            case -242217677: 
            case -114431171: 
            case 3373707: 
            case 3575610: 
            case 71904295: 
            case 92734940: 
            case 270456726: 
            case 275994924: 
            case 413906616: 
            case 761243362: 
            case 933304964: 
            case 1081186720: 
            case 1234314708: 
            case 1568910518: 
            case 1807639849: 
            case 1930630086: 
            case 2070339882: {
                break;
            }
            default: {
                LOG.warn("Ignoring unknown start tag <" + qName + "> with hashCode=" + qName.hashCode());
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        assert (qName.equals(this.stack.peek()));
        String text = this.buffer.toString().trim();
        this.buffer.setLength(0);
        block0 : switch (qName.hashCode()) {
            case 3373707: {
                String parent = (String)this.stack.get(this.stack.size() - 2);
                switch (parent.hashCode()) {
                    case -1498874611: {
                        this.tobagoConfig.setName(text);
                        break block0;
                    }
                    case -1392885889: {
                        this.tobagoConfig.addBefore(text);
                        break block0;
                    }
                    case 92734940: {
                        this.tobagoConfig.addAfter(text);
                        break block0;
                    }
                    case -494845757: {
                        this.currentRenderer.setName(text);
                        if (this.currentTheme != null) {
                            ((RenderersConfigImpl)this.currentTheme.getRenderersConfig()).addRenderer(this.currentRenderer);
                            break block0;
                        }
                        ((RenderersConfigImpl)this.tobagoConfig.getRenderersConfig()).addRenderer(this.currentRenderer);
                        break block0;
                    }
                    case 1515774935: {
                        this.currentTheme.setName(text);
                        break block0;
                    }
                }
                LOG.warn("Ignoring unknown parent <" + qName + "> of tag <name>");
                break;
            }
            case -114431171: {
                this.tobagoConfig.setDefaultThemeName(text);
                break;
            }
            case -822303766: {
                this.tobagoConfig.addSupportedThemeName(text);
                break;
            }
            case -385546674: {
                this.tobagoConfig.addResourceDir(text);
                break;
            }
            case 413906616: {
                this.tobagoConfig.setCreateSessionSecret(text);
                break;
            }
            case 275994924: {
                this.tobagoConfig.setCheckSessionSecret(text);
                break;
            }
            case 270456726: {
                this.tobagoConfig.setPreventFrameAttacks(Boolean.parseBoolean(text));
                break;
            }
            case -1238451304: {
                this.tobagoConfig.setSetNosniffHeader(Boolean.parseBoolean(text));
                break;
            }
            case -962590641: {
                this.tobagoConfig.getContentSecurityPolicy().getDirectiveList().add(text);
                break;
            }
            case -1081305560: {
                this.currentRenderer.addSupportedMarkup(text);
                break;
            }
            case 1568910518: {
                this.currentTheme.setDisplayName(text);
                break;
            }
            case 933304964: {
                this.currentTheme.setResourcePath(text);
                break;
            }
            case 761243362: {
                this.currentTheme.setFallbackName(text);
                break;
            }
            case 1515774935: {
                this.currentTheme = null;
                break;
            }
            case -1407102089: {
                this.currentTheme.setVersioned(Boolean.parseBoolean(text));
                break;
            }
            case -1983070683: {
                this.production = null;
                break;
            }
            case 1994055129: {
                this.exclude = false;
                break;
            }
            case -974266412: {
                this.tobagoConfig.setSanitizerClass(text);
                break;
            }
            case 1807639849: {
                if (this.properties != null) {
                    this.tobagoConfig.setSanitizerProperties(this.properties);
                }
                this.properties = null;
                break;
            }
            case 96667762: {
                this.properties.setProperty(this.entryKey, text);
                this.entryKey = null;
                break;
            }
            case 2070339882: {
                this.tobagoConfig.setAutoAccessKeyFromLabel(Boolean.parseBoolean(text));
                break;
            }
            case -879394870: {
                this.tobagoConfig.setClassicDateTimePicker(text);
                break;
            }
            case -612557761: {
                this.extension = text;
                break;
            }
            case 3575610: {
                this.type = text;
                break;
            }
            case -242217677: {
                this.tobagoConfig.addMimeType(this.extension, this.type);
                break;
            }
            case -1498874611: 
            case -1392885889: 
            case -926053069: 
            case -907685685: 
            case -494845757: 
            case -255617156: 
            case 71904295: 
            case 92734940: 
            case 109780401: 
            case 1081186720: 
            case 1207440139: 
            case 1234314708: 
            case 1839650832: 
            case 1930630086: {
                break;
            }
            default: {
                LOG.warn("Ignoring unknown end tag <" + qName + ">");
            }
        }
        this.stack.pop();
    }

    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    private void validate(URL url, TobagoConfigVersion version) throws URISyntaxException, SAXException, IOException {
        Schema schema;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if ("2.3".equals(version.getVersion())) {
            schema = schemaFactory.newSchema(this.getClass().getResource("/org/apache/myfaces/tobago/config/tobago-config-2.3.xsd"));
        } else if ("2.0.6".equals(version.getVersion())) {
            schema = schemaFactory.newSchema(this.getClass().getResource("/org/apache/myfaces/tobago/config/tobago-config-2.0.6.xsd"));
        } else if ("2.0".equals(version.getVersion())) {
            schema = schemaFactory.newSchema(this.getClass().getResource("/org/apache/myfaces/tobago/config/tobago-config-2.0.xsd"));
        } else if ("1.6".equals(version.getVersion())) {
            LOG.warn("Using deprecated schema with version attribute 1.6 in file: '" + url + "'");
            schema = schemaFactory.newSchema(this.getClass().getResource("/org/apache/myfaces/tobago/config/tobago-config-1.6.xsd"));
        } else if ("1.5".equals(version.getVersion())) {
            schema = schemaFactory.newSchema(this.getClass().getResource("/org/apache/myfaces/tobago/config/tobago-config-1.5.xsd"));
        } else {
            throw new SAXException("Using unknown version attribute '" + version.getVersion() + "' in file: '" + url + "'");
        }
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(url.openStream());
        validator.validate(source);
    }
}

