/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PageAction {
    FIRST("First"),
    NEXT("Next"),
    PREV("Prev"),
    LAST("Last"),
    TO_ROW("ToRow"),
    TO_PAGE("ToPage");

    private String token;
    private static final Map<String, PageAction> MAPPING;

    private PageAction(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public static PageAction parse(String name) throws IllegalArgumentException {
        PageAction value = MAPPING.get(name);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Unknown name for PageAction: '" + name + "'");
    }

    static {
        MAPPING = new HashMap<String, PageAction>();
        for (PageAction action : PageAction.values()) {
            MAPPING.put(action.getToken(), action);
        }
    }
}

