/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.compat;

import java.util.Comparator;
import java.util.Iterator;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.validator.MethodExpressionValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.event.ValueExpressionPopupActionListener;
import org.apache.myfaces.tobago.event.ValueExpressionResetInputActionListener;
import org.apache.myfaces.tobago.event.ValueExpressionTabChangeListener;
import org.apache.myfaces.tobago.util.ValueExpressionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacesUtilsEL {
    private static final Logger LOG = LoggerFactory.getLogger(FacesUtilsEL.class);

    private FacesUtilsEL() {
    }

    public static boolean invokeOnComponent(FacesContext context, UIComponent component, String clientId, ContextCallback callback) {
        String thisClientId = component.getClientId(context);
        if (clientId.equals(thisClientId)) {
            callback.invokeContextCallback(context, component);
            return true;
        }
        return component instanceof NamingContainer ? clientId.startsWith(thisClientId) && clientId.charAt(thisClientId.length()) == UINamingContainer.getSeparatorChar((FacesContext)context) && FacesUtilsEL.invokeOnComponentFacetsAndChildren(context, component, clientId, callback) : FacesUtilsEL.invokeOnComponentFacetsAndChildren(context, component, clientId, callback);
    }

    private static boolean invokeOnComponentFacetsAndChildren(FacesContext context, UIComponent component, String clientId, ContextCallback callback) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!child.invokeOnComponent(context, clientId, callback)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void invokeMethodBinding(FacesContext facesContext, MethodBinding methodBinding, FacesEvent event) {
        if (methodBinding != null && event != null) {
            try {
                methodBinding.invoke(facesContext, new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public static void invokeMethodExpression(FacesContext facesContext, MethodExpression methodExpression, FacesEvent event) {
        if (methodExpression != null && event != null) {
            try {
                methodExpression.invoke(facesContext.getELContext(), new Object[]{event});
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
    }

    @Deprecated
    public static Object getValueFromValueBindingOrValueExpression(FacesContext context, UIComponent component, String name) {
        return component.getValueExpression(name).getValue(context.getELContext());
    }

    public static boolean hasValueBindingOrValueExpression(UIComponent component, String name) {
        return component.getValueExpression(name) != null;
    }

    public static boolean isReadonlyValueBindingOrValueExpression(FacesContext context, UIComponent component, String name) {
        return component.getValueExpression(name).isReadOnly(context.getELContext());
    }

    public static String getExpressionString(UIComponent component, String name) {
        return component.getValueExpression(name).getExpressionString();
    }

    public static void setValueOfBindingOrExpression(FacesContext context, Object value, UIComponent component, String bindingName) {
        ValueExpression ve = component.getValueExpression(bindingName);
        if (ve != null) {
            ve.setValue(context.getELContext(), value);
        }
    }

    public static void setValueOfBindingOrExpression(FacesContext context, Object value, Object bindingOrExpression) {
        if (bindingOrExpression instanceof ValueExpression) {
            ValueExpression ve = (ValueExpression)bindingOrExpression;
            ve.setValue(context.getELContext(), value);
        }
    }

    public static void copyValueBindingOrValueExpression(UIComponent fromComponent, String fromName, UIComponent toComponent, String toName) {
        ValueExpression ve = fromComponent.getValueExpression(fromName);
        if (ve != null) {
            toComponent.setValueExpression(toName, ve);
        }
    }

    public static Object getValueFromBindingOrExpression(Object obj) {
        if (obj instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)obj;
            return expression.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return null;
    }

    @Deprecated
    public static Object createExpressionOrBinding(String string) {
        return FacesUtilsEL.createValueExpression(string);
    }

    public static ValueExpression createValueExpression(String string) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        return expressionFactory.createValueExpression(facesContext.getELContext(), string, Object.class);
    }

    public static void setValidator(EditableValueHolder editableValueHolder, Object validator) {
        if (validator instanceof MethodExpression) {
            editableValueHolder.addValidator((Validator)new MethodExpressionValidator((MethodExpression)validator));
        } else {
            LOG.error("Unknown instance for validator: " + (validator != null ? validator.getClass().getName() : "<null>"));
        }
    }

    public static void setConverter(ValueHolder valueHolder, Object converterExpression) {
        if (converterExpression instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)converterExpression;
            if (!expression.isLiteralText()) {
                ((UIComponent)valueHolder).setValueExpression("converter", expression);
            } else {
                valueHolder.setConverter(FacesContext.getCurrentInstance().getApplication().createConverter(expression.getExpressionString()));
            }
        }
    }

    public static void setBindingOrExpression(UIComponent component, String name, Object valueBindingOrExpression) {
        component.setValueExpression(name, (ValueExpression)valueBindingOrExpression);
    }

    public static void addBindingOrExpressionTabChangeListener(TabChangeSource source, String type, Object bindingOrExpression) {
        if (bindingOrExpression instanceof ValueExpression) {
            source.addTabChangeListener(new ValueExpressionTabChangeListener(type, (ValueExpression)bindingOrExpression));
        }
    }

    public static Comparator getBindingOrExpressionComparator(FacesContext facesContext, UIComponent child, String var, boolean descending, Comparator comparator) {
        ValueExpression valueBinding = child.getValueExpression("value");
        return new ValueExpressionComparator(facesContext, var, valueBinding, descending, comparator);
    }

    public static void addBindingOrExpressionPopupActionListener(ActionSource actionSource, Object bindingOrExpression) {
        actionSource.addActionListener((ActionListener)new ValueExpressionPopupActionListener((ValueExpression)bindingOrExpression));
    }

    public static void addBindingOrExpressionResetActionListener(ActionSource actionSource, Object bindingOrExpression) {
        actionSource.addActionListener((ActionListener)new ValueExpressionResetInputActionListener((ValueExpression)bindingOrExpression));
    }
}

