/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.ajax.AjaxUtils;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.ajax.AjaxResponseRenderer;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.util.ApplyRequestValuesCallback;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.apache.myfaces.tobago.util.ProcessValidationsCallback;
import org.apache.myfaces.tobago.util.TobagoCallback;
import org.apache.myfaces.tobago.util.UpdateModelValuesCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class UIViewRoot
extends javax.faces.component.UIViewRoot {
    private static final Logger LOG = LoggerFactory.getLogger(UIViewRoot.class);
    private static final TobagoCallback APPLY_REQUEST_VALUES_CALLBACK = new ApplyRequestValuesCallback();
    private static final ContextCallback PROCESS_VALIDATION_CALLBACK = new ProcessValidationsCallback();
    private static final ContextCallback UPDATE_MODEL_VALUES_CALLBACK = new UpdateModelValuesCallback();
    private List<FacesEvent> events;

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        ClientProperties clientProperties = ClientProperties.getInstance((FacesContext)this.getFacesContext());
        clientProperties.setLocale(locale);
        clientProperties.updateUserAgent(this.getFacesContext());
    }

    public void broadcastEventsForPhase(FacesContext context, PhaseId phaseId) {
        this.broadcastForPhase(phaseId);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this.events == null) {
            this.events = new ArrayList<FacesEvent>();
        }
        this.events.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastForPhase(PhaseId phaseId) {
        if (this.events == null) {
            return;
        }
        boolean abort = false;
        int phaseIdOrdinal = phaseId.getOrdinal();
        ListIterator<FacesEvent> listiterator = this.events.listIterator();
        while (listiterator.hasNext()) {
            FacesEvent event = listiterator.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != PhaseId.ANY_PHASE.getOrdinal() && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                source.broadcast(event);
            }
            catch (FacesException e) {
                for (Throwable fe = e; fe != null; fe = fe.getCause()) {
                    if (!(fe instanceof AbortProcessingException)) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("AbortProcessingException caught!");
                    }
                    abort = true;
                    break;
                }
                if (abort) break;
                throw e;
            }
            finally {
                try {
                    listiterator.remove();
                }
                catch (ConcurrentModificationException cme) {
                    int eventIndex = listiterator.previousIndex();
                    this.events.remove(eventIndex);
                }
            }
        }
        if (abort) {
            this.clearEvents();
        }
    }

    private void clearEvents() {
        this.events = null;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Map ajaxComponents = AjaxInternalUtils.parseAndStoreComponents((FacesContext)context);
        if (ajaxComponents != null) {
            AbstractUIPage page = ComponentUtils.findPage((FacesContext)context);
            page.decode(context);
            page.markSubmittedForm(context);
            FacesContextUtils.setAjax((FacesContext)context, (boolean)true);
            this.decodeActionComponent(context, page, ajaxComponents);
            for (Map.Entry entry : ajaxComponents.entrySet()) {
                FacesContextUtils.setAjaxComponentId((FacesContext)context, (String)((String)entry.getKey()));
                this.invokeOnComponent(context, (String)entry.getKey(), (ContextCallback)APPLY_REQUEST_VALUES_CALLBACK);
            }
        } else {
            super.processDecodes(context);
        }
        this.broadcastForPhase(PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    private void decodeActionComponent(FacesContext facesContext, AbstractUIPage page, Map<String, UIComponent> ajaxComponents) {
        String actionId = page.getActionId();
        UIComponent actionComponent = null;
        if (actionId != null && (actionComponent = this.findComponent(actionId)) == null && FacesVersion.supports20() && FacesVersion.isMyfaces()) {
            String bugActionId = actionId.replaceAll(":\\d+:", ":");
            try {
                actionComponent = this.findComponent(bugActionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (actionComponent == null) {
            return;
        }
        for (UIComponent ajaxComponent : ajaxComponents.values()) {
            for (UIComponent component = actionComponent; component != null; component = component.getParent()) {
                if (component != ajaxComponent) continue;
                return;
            }
        }
        this.invokeOnComponent(facesContext, actionId, (ContextCallback)APPLY_REQUEST_VALUES_CALLBACK);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Map ajaxComponents = AjaxInternalUtils.getAjaxComponents((FacesContext)context);
        if (ajaxComponents != null) {
            for (Map.Entry entry : ajaxComponents.entrySet()) {
                FacesContextUtils.setAjaxComponentId((FacesContext)context, (String)((String)entry.getKey()));
                this.invokeOnComponent(context, (String)entry.getKey(), PROCESS_VALIDATION_CALLBACK);
            }
        } else {
            super.processValidators(context);
        }
        this.broadcastForPhase(PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Map ajaxComponents = AjaxInternalUtils.getAjaxComponents((FacesContext)context);
        if (ajaxComponents != null) {
            for (Map.Entry entry : ajaxComponents.entrySet()) {
                this.invokeOnComponent(context, (String)entry.getKey(), UPDATE_MODEL_VALUES_CALLBACK);
            }
        } else {
            super.processUpdates(context);
        }
        this.broadcastForPhase(PhaseId.UPDATE_MODEL_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastForPhase(PhaseId.INVOKE_APPLICATION);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public boolean getRendersChildren() {
        if (AjaxUtils.isAjaxRequest((FacesContext)FacesContext.getCurrentInstance())) {
            return true;
        }
        return super.getRendersChildren();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (AjaxUtils.isAjaxRequest((FacesContext)context)) {
            new AjaxResponseRenderer().renderResponse(context);
        } else {
            super.encodeChildren(context);
        }
    }
}

